/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.CallingBackColoredTreeCellRenderer;
import com.intellij.ide.errorTreeView.EditableMessageElement;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeEditor
extends AbstractCellEditor
implements TreeCellEditor,
MouseMotionListener {
    private final MyWrapperEditor myWrapperEditor;
    private final CallingBackColoredTreeCellRenderer myColoredTreeCellRenderer;
    private final CellEditorDelegate myRightCellRenderer;
    private final JTree myTree;

    public static void install(Tree tree2) {
        NewErrorTreeEditor treeEditor = new NewErrorTreeEditor((JTree)tree2);
        tree2.setCellEditor((TreeCellEditor)treeEditor);
        tree2.addMouseMotionListener((MouseMotionListener)treeEditor);
        tree2.setEditable(true);
    }

    private NewErrorTreeEditor(JTree tree2) {
        this.myTree = tree2;
        this.myRightCellRenderer = new CellEditorDelegate();
        this.myColoredTreeCellRenderer = new CallingBackColoredTreeCellRenderer();
        this.myWrapperEditor = new MyWrapperEditor((TreeCellRenderer)((Object)this.myColoredTreeCellRenderer), this.myRightCellRenderer);
    }

    @Override
    public boolean isCellEditable(EventObject e2) {
        Object node;
        if (e2 instanceof MouseEvent) {
            Point point = ((MouseEvent)e2).getPoint();
            TreePath location = this.myTree.getClosestPathForLocation(point.x, point.y);
            node = location.getLastPathComponent();
        } else {
            node = this.myTree.getLastSelectedPathComponent();
        }
        ErrorTreeElement element = NewErrorTreeEditor.getElement(node);
        return element instanceof EditableMessageElement;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row) {
        ErrorTreeElement element = NewErrorTreeEditor.getElement(value2);
        if (element instanceof EditableMessageElement) {
            EditableMessageElement editableMessageElement = (EditableMessageElement)((Object)element);
            CustomizeColoredTreeCellRenderer leftSelfRenderer = editableMessageElement.getLeftSelfRenderer();
            TreeCellEditor rightSelfEditor = editableMessageElement.getRightSelfEditor();
            this.myColoredTreeCellRenderer.setCurrentCallback(leftSelfRenderer);
            this.myRightCellRenderer.setCurrentCallback(rightSelfEditor);
            return this.myWrapperEditor.getTreeCellEditorComponent(tree2, value2, selected, expanded, leaf, row);
        }
        return this.myTree.getCellRenderer().getTreeCellRendererComponent(tree2, value2, selected, expanded, leaf, row, true);
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        ErrorTreeElement element;
        TreePath treePath;
        JTree tree2 = (JTree)e2.getSource();
        int selRow = tree2.getRowForLocation(e2.getX(), e2.getY());
        if (selRow != -1 && (treePath = tree2.getPathForRow(selRow)) != null && treePath != tree2.getEditingPath() && (element = NewErrorTreeEditor.getElement(treePath.getLastPathComponent())) instanceof EditableMessageElement && ((EditableMessageElement)((Object)element)).startEditingOnMouseMove()) {
            if (!tree2.isRowSelected(selRow)) {
                tree2.setSelectionRow(selRow);
            }
            tree2.startEditingAtPath(treePath);
        }
    }

    @Nullable
    private static ErrorTreeElement getElement(@Nullable Object value2) {
        if (!(value2 instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
        if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
            return null;
        }
        return ((ErrorTreeNodeDescriptor)((Object)userObject)).getElement();
    }

    private static class CellEditorDelegate
    extends AbstractCellEditor
    implements TreeCellEditor {
        private TreeCellEditor myCurrentCallback;

        private CellEditorDelegate() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row) {
            return this.myCurrentCallback.getTreeCellEditorComponent(tree2, value2, selected, expanded, leaf, row);
        }

        public void setCurrentCallback(TreeCellEditor currentCallback) {
            this.myCurrentCallback = currentCallback;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private static class MyWrapperEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeCellRenderer myLeft;
        private final TreeCellEditor myRight;
        private final JPanel myPanel;

        public TreeCellRenderer getLeft() {
            return this.myLeft;
        }

        public TreeCellEditor getRight() {
            return this.myRight;
        }

        public MyWrapperEditor(TreeCellRenderer left, TreeCellEditor right) {
            this.myLeft = left;
            this.myRight = right;
            this.myPanel = new JPanel(new BorderLayout());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row) {
            this.myPanel.removeAll();
            this.myPanel.add(this.myLeft.getTreeCellRendererComponent(tree2, value2, false, expanded, leaf, row, true), "West");
            this.myPanel.add(this.myRight.getTreeCellEditorComponent(tree2, value2, selected, expanded, leaf, row), "East");
            if (UIUtil.isFullRowSelectionLAF()) {
                this.myPanel.setBackground(selected ? UIUtil.getTreeSelectionBackground() : null);
            } else if (WideSelectionTreeUI.isWideSelection((JTree)tree2)) {
                if (selected) {
                    this.myPanel.setBackground(UIUtil.getTreeSelectionBackground());
                }
            } else if (selected) {
                this.myPanel.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.myPanel.setBackground(null);
            }
            if (value2 instanceof LoadingNode) {
                this.myPanel.setForeground((Color)JBColor.GRAY);
            } else {
                this.myPanel.setForeground(tree2.getForeground());
            }
            if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel() && selected || WideSelectionTreeUI.isWideSelection((JTree)tree2)) {
                this.myPanel.setOpaque(false);
            }
            return this.myPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

