/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExtensionsRootType", storages={@Storage(value="extensionsRootType.xml", roamingType=RoamingType.DISABLED)})
class ResourceVersions
implements PersistentStateComponent<State> {
    private State myState = new State();

    ResourceVersions() {
    }

    @NotNull
    public static ResourceVersions getInstance() {
        ResourceVersions resourceVersions = (ResourceVersions)ServiceManager.getService(ResourceVersions.class);
        if (resourceVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions", "getInstance"));
        }
        return resourceVersions;
    }

    public boolean shouldUpdateResourcesOf(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/extensionResources/ResourceVersions", "shouldUpdateResourcesOf"));
        }
        return this.myState.isNewOrUpgraded(plugin);
    }

    public void resourcesUpdated(@NotNull IdeaPluginDescriptor of) {
        if (of == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "of", "com/intellij/ide/extensionResources/ResourceVersions", "resourcesUpdated"));
        }
        this.myState.rememberPlugin(of);
    }

    @Nullable
    public State getState() {
        return this.myState.clone();
    }

    public void loadState(State loaded) {
        loaded.forgetDisabledPlugins();
        this.myState = loaded;
    }

    static class State
    implements Serializable,
    Cloneable {
        @Tag(value="pluginVersions")
        @MapAnnotation(entryTagName="plugin", keyAttributeName="id", valueAttributeName="version", surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        private Map<String, String> myPluginIdToVersion = ContainerUtil.newHashMap();

        State() {
        }

        public boolean isNewOrUpgraded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/extensionResources/ResourceVersions$State", "isNewOrUpgraded"));
            }
            return !StringUtil.equals((CharSequence)this.myPluginIdToVersion.get(State.getId(pluginDescriptor)), (CharSequence)State.getVersion(pluginDescriptor));
        }

        public void rememberPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/extensionResources/ResourceVersions$State", "rememberPlugin"));
            }
            this.myPluginIdToVersion.put(State.getId(pluginDescriptor), State.getVersion(pluginDescriptor));
        }

        public void forgetDisabledPlugins() {
            HashMap newMapping = ContainerUtil.newHashMap();
            for (String pluginIdString : this.myPluginIdToVersion.keySet()) {
                IdeaPluginDescriptor plugin = PluginManager.getPlugin(PluginId.findId((String[])new String[]{pluginIdString}));
                if (plugin == null || !plugin.isEnabled()) continue;
                newMapping.put(pluginIdString, this.myPluginIdToVersion.get(pluginIdString));
            }
            this.myPluginIdToVersion = newMapping;
        }

        public State clone() {
            try {
                return (State)super.clone();
            }
            catch (CloneNotSupportedException e2) {
                ExtensionsRootType.LOG.error((Throwable)e2);
                return null;
            }
        }

        @NotNull
        private static String getId(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/extensionResources/ResourceVersions$State", "getId"));
            }
            PluginId pluginId = plugin.getPluginId();
            String string2 = pluginId != null ? pluginId.getIdString() : "com.intellij";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getId"));
            }
            return string2;
        }

        @NotNull
        private static String getVersion(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
            }
            if (!plugin.isBundled()) {
                String string2 = (String)ObjectUtils.assertNotNull((Object)plugin.getVersion());
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
                }
                return string2;
            }
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            BuildNumber build2 = appInfo.getBuild();
            if (!build2.isSnapshot()) {
                String string3 = build2.asString();
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
                }
                return string3;
            }
            String string4 = build2.getProductCode() + "-" + build2.getBaselineVersion() + "-" + appInfo.getBuildDate().getTimeInMillis();
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
            }
            return string4;
        }
    }
}

