/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.externalComponents;

import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalComponentManagerImpl
extends ExternalComponentManager {
    private final Set<ExternalComponentSource> mySources = new HashSet<ExternalComponentSource>();

    @Override
    @NotNull
    public Iterable<ExternalComponentSource> getComponentSources() {
        Set<ExternalComponentSource> set2 = this.mySources;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/externalComponents/ExternalComponentManagerImpl", "getComponentSources"));
        }
        return set2;
    }

    @Override
    public void registerComponentSource(@NotNull ExternalComponentSource site) {
        if (site == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "site", "com/intellij/ide/externalComponents/ExternalComponentManagerImpl", "registerComponentSource"));
        }
        this.mySources.add(site);
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        List<String> knownSources = updateSettings.getKnownExternalUpdateSources();
        if (!knownSources.contains(site.getName())) {
            knownSources.add(site.getName());
            updateSettings.getEnabledExternalUpdateSources().add(site.getName());
            List<String> channels = site.getAllChannels();
            if (channels != null) {
                updateSettings.getExternalUpdateChannels().put(site.getName(), channels.get(0));
            }
        }
    }

    @Override
    @Nullable
    public UpdatableExternalComponent findExistingComponentMatching(@NotNull UpdatableExternalComponent update2, @NotNull ExternalComponentSource source) {
        if (update2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/ide/externalComponents/ExternalComponentManagerImpl", "findExistingComponentMatching"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/externalComponents/ExternalComponentManagerImpl", "findExistingComponentMatching"));
        }
        Collection<UpdatableExternalComponent> existing = source.getCurrentVersions();
        for (UpdatableExternalComponent c2 : existing) {
            if (!update2.isUpdateFor(c2)) continue;
            return c2;
        }
        return null;
    }
}

