/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ui.treeStructure.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeUtil {
    @NotNull
    public static FavoritesTreeNodeDescriptor[] getSelectedNodeDescriptors(DnDAwareTree tree2) {
        TreePath[] path = tree2.getSelectionPaths();
        if (path == null) {
            if (FavoritesTreeNodeDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getSelectedNodeDescriptors"));
            }
            return FavoritesTreeNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<FavoritesTreeNodeDescriptor> result2 = new ArrayList<FavoritesTreeNodeDescriptor>();
        for (TreePath treePath : path) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor)) continue;
            FavoritesTreeNodeDescriptor treeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
            result2.add(treeNodeDescriptor);
        }
        FavoritesTreeNodeDescriptor[] favoritesTreeNodeDescriptorArray = result2.toArray(new FavoritesTreeNodeDescriptor[result2.size()]);
        if (favoritesTreeNodeDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getSelectedNodeDescriptors"));
        }
        return favoritesTreeNodeDescriptorArray;
    }

    public static List<AbstractTreeNode> getLogicalPathToSelected(Tree tree2) {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        TreePath selectionPath = tree2.getSelectionPath();
        return FavoritesTreeUtil.getLogicalPathTo(result2, selectionPath);
    }

    public static List<Integer> getLogicalIndexPathTo(TreePath selectionPath) {
        Object uo;
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        Object component = selectionPath.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoritesTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode.getIndex());
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    public static List<AbstractTreeNode> getLogicalPathTo(List<AbstractTreeNode> result2, TreePath selectionPath) {
        Object uo;
        Object component = selectionPath.getLastPathComponent();
        if (component instanceof DefaultMutableTreeNode && (uo = ((DefaultMutableTreeNode)component).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
            for (AbstractTreeNode treeNode = ((FavoritesTreeNodeDescriptor)((Object)uo)).getElement(); !(treeNode instanceof FavoritesListNode) && treeNode != null; treeNode = treeNode.getParent()) {
                result2.add(treeNode);
            }
            Collections.reverse(result2);
            return result2;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static FavoritesListNode extractParentList(FavoritesTreeNodeDescriptor descriptor2) {
        AbstractTreeNode node;
        for (AbstractTreeNode current = node = descriptor2.getElement(); current != null; current = current.getParent()) {
            if (!(current instanceof FavoritesListNode)) continue;
            return (FavoritesListNode)current;
        }
        return null;
    }

    static FavoritesListProvider getProvider(@NotNull FavoritesManager manager, @NotNull FavoritesTreeNodeDescriptor descriptor2) {
        AbstractTreeNode treeNode;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getProvider"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/favoritesTreeView/FavoritesTreeUtil", "getProvider"));
        }
        for (treeNode = descriptor2.getElement(); treeNode != null && !(treeNode instanceof FavoritesListNode); treeNode = treeNode.getParent()) {
        }
        if (treeNode != null) {
            String name = (String)((FavoritesListNode)treeNode).getValue();
            return manager.getListProvider(name);
        }
        return null;
    }
}

