/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.UsageFavoriteNodeProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import java.util.Collection;

public class ImportUsagesAction
extends AnAction {
    public ImportUsagesAction() {
        super("To Favorites", "To Favorites", AllIcons.Toolwindows.ToolWindowFavorites);
    }

    public void update(AnActionEvent e2) {
        DataContext dc2 = e2.getDataContext();
        boolean enabled = this.isEnabled(dc2);
        e2.getPresentation().setEnabled(enabled);
    }

    private boolean isEnabled(DataContext dc2) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc2);
        Usage[] usages = (Usage[])UsageView.USAGES_KEY.getData(dc2);
        return project2 != null && usages != null && usages.length > 0;
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dc2 = e2.getDataContext();
        boolean enabled = this.isEnabled(dc2);
        if (!enabled) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc2);
        Collection<AbstractTreeNode> nodes = new UsageFavoriteNodeProvider().getFavoriteNodes(dc2, ViewSettings.DEFAULT);
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        if (nodes != null && !nodes.isEmpty()) {
            favoritesManager.addRoots("Current task", nodes);
        }
    }
}

