/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.AddToNewFavoritesListAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddToFavoritesActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        if (e2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesActionGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesActionGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<String> availableFavoritesLists = FavoritesManager.getInstance(project2).getAvailableFavoritesListNames();
        availableFavoritesLists.remove(FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e2.getDataContext()));
        if (availableFavoritesLists.isEmpty()) {
            AnAction[] anActionArray = new AnAction[]{new AddToNewFavoritesListAction()};
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesActionGroup", "getChildren"));
            }
            return anActionArray;
        }
        AnAction[] actions2 = new AnAction[availableFavoritesLists.size() + 2];
        int idx = 0;
        for (String favoritesList : availableFavoritesLists) {
            actions2[idx++] = new AddToFavoritesAction(favoritesList);
        }
        actions2[idx++] = Separator.getInstance();
        actions2[idx] = new AddToNewFavoritesListAction();
        if (actions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/actions/AddToFavoritesActionGroup", "getChildren"));
        }
        return actions2;
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        try {
            e2.getPresentation().setVisible(AddToFavoritesAction.canCreateNodes(e2));
        }
        catch (IndexNotReadyException e1) {
            e2.getPresentation().setVisible(false);
        }
    }
}

