/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DeleteFromFavoritesAction
extends AnActionButton
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + DeleteFromFavoritesAction.class.getName()));

    public DeleteFromFavoritesAction() {
        super(IdeBundle.message((String)"action.remove.from.current.favorites", (Object[])new Object[0]), IconUtil.getRemoveIcon());
    }

    public void actionPerformed(AnActionEvent e2) {
        String listName;
        DataContext dataContext = e2.getDataContext();
        Project project2 = e2.getProject();
        FavoritesViewTreeBuilder builder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(dataContext));
        if (project2 == null || builder == null) {
            return;
        }
        Set selection = builder.getSelectedElements();
        if (selection.isEmpty()) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        FavoritesListProvider provider = favoritesManager.getListProvider(listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext));
        if (provider != null && provider.willHandle(CommonActionsPanel.Buttons.REMOVE, project2, selection)) {
            provider.handle(CommonActionsPanel.Buttons.REMOVE, project2, selection, builder.getTree());
            return;
        }
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        DnDAwareTree tree2 = (DnDAwareTree)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_KEY.getData(dataContext));
        assert (roots != null && tree2 != null);
        HashMap toRemove = new HashMap();
        for (FavoritesTreeNodeDescriptor root : roots) {
            AbstractTreeNode node = root.getElement();
            if (node instanceof FavoritesListNode) {
                favoritesManager.removeFavoritesList((String)node.getValue());
                continue;
            }
            FavoritesListNode listNode = FavoritesTreeUtil.extractParentList(root);
            LOG.assertTrue(listNode != null);
            String name = listNode.getName();
            if (!toRemove.containsKey(name)) {
                toRemove.put(name, new ArrayList());
            }
            ((List)toRemove.get(name)).add(node);
        }
        for (String name : toRemove.keySet()) {
            favoritesManager.removeRoot(name, (List)toRemove.get(name));
        }
    }

    public void updateButton(AnActionEvent e2) {
        e2.getPresentation().setText(this.getTemplatePresentation().getText());
        DataContext dataContext = e2.getDataContext();
        Project project2 = e2.getProject();
        FavoritesViewTreeBuilder builder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(dataContext));
        if (project2 == null || builder == null) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        Set selection = builder.getSelectedElements();
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        if (listName == null) {
            e2.getPresentation().setText(CommonActionsPanel.Buttons.REMOVE.getText());
            e2.getPresentation().setEnabled(false);
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        FavoritesListProvider provider = favoritesManager.getListProvider(listName);
        if (provider != null) {
            boolean willHandle = provider.willHandle(CommonActionsPanel.Buttons.REMOVE, project2, selection);
            e2.getPresentation().setEnabled(willHandle);
            if (willHandle) {
                e2.getPresentation().setText(provider.getCustomName(CommonActionsPanel.Buttons.REMOVE));
            } else {
                e2.getPresentation().setText(CommonActionsPanel.Buttons.REMOVE.getText());
            }
            return;
        }
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        if (roots == null || roots.length == 0 || selection.isEmpty()) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        for (Object o2 : selection) {
            if (o2 instanceof AbstractTreeNode) {
                AbstractTreeNode node = (AbstractTreeNode)o2;
                int deep = DeleteFromFavoritesAction.getDeep(node);
                if (deep == 2 || deep == 3) continue;
                e2.getPresentation().setEnabled(false);
                return;
            }
            e2.getPresentation().setEnabled(false);
            return;
        }
    }

    private static int getDeep(AbstractTreeNode node) {
        int result2 = 0;
        while (node != null) {
            node = node.getParent();
            ++result2;
        }
        return result2;
    }
}

