/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CommonActionsPanel;
import java.util.Set;

public class EditFavoritesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        Project project2 = e2.getProject();
        FavoritesViewTreeBuilder treeBuilder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(e2.getDataContext()));
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e2.getDataContext());
        if (project2 == null || treeBuilder == null || listName == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        FavoritesListProvider provider = favoritesManager.getListProvider(listName);
        Set selection = treeBuilder.getSelectedElements();
        if (provider != null && provider.willHandle(CommonActionsPanel.Buttons.EDIT, project2, selection)) {
            provider.handle(CommonActionsPanel.Buttons.EDIT, project2, selection, treeBuilder.getTree());
            return;
        }
        favoritesManager.renameList(project2, listName);
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setText(this.getTemplatePresentation().getText());
        e2.getPresentation().setIcon(CommonActionsPanel.Buttons.EDIT.getIcon());
        e2.getPresentation().setEnabled(true);
        Project project2 = e2.getProject();
        FavoritesViewTreeBuilder treeBuilder = (FavoritesViewTreeBuilder)((Object)FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(e2.getDataContext()));
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e2.getDataContext());
        if (project2 == null || treeBuilder == null || listName == null) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        FavoritesListProvider provider = favoritesManager.getListProvider(listName);
        Set selection = treeBuilder.getSelectedElements();
        if (provider != null) {
            e2.getPresentation().setEnabled(provider.willHandle(CommonActionsPanel.Buttons.EDIT, project2, selection));
            e2.getPresentation().setText(provider.getCustomName(CommonActionsPanel.Buttons.EDIT));
        }
    }
}

