/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.EditFileTemplatesAction;
import com.intellij.ide.fileTemplates.CreateFromTemplateActionReplacer;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.fileTemplates.ui.SelectTemplateDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateGroup
extends ActionGroup
implements DumbAware {
    public void update(AnActionEvent e2) {
        super.update(e2);
        Presentation presentation = e2.getPresentation();
        Project project2 = e2.getProject();
        if (project2 != null) {
            FileTemplate[] allTemplates;
            for (FileTemplate template : allTemplates = FileTemplateManager.getInstance(project2).getAllTemplates()) {
                if (!CreateFromTemplateGroup.canCreateFromTemplate(e2, template)) continue;
                presentation.setEnabled(true);
                return;
            }
        }
        presentation.setEnabled(false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        boolean showAll;
        if (e2 == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/actions/CreateFromTemplateGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        Project project2 = e2.getProject();
        if (project2 == null || project2.isDisposed()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/actions/CreateFromTemplateGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        FileTemplateManager manager = FileTemplateManager.getInstance(project2);
        FileTemplate[] templates = manager.getAllTemplates();
        boolean bl = showAll = templates.length <= 25;
        if (!showAll) {
            Collection<String> recentNames = manager.getRecentNames();
            templates = new FileTemplate[recentNames.size()];
            int i2 = 0;
            for (String name : recentNames) {
                templates[i2] = manager.getTemplate(name);
                ++i2;
            }
        }
        Arrays.sort(templates, (template1, template2) -> {
            if (template1.isTemplateOfType((FileType)StdFileTypes.JAVA) && !template2.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
                return -1;
            }
            if (template2.isTemplateOfType((FileType)StdFileTypes.JAVA) && !template1.isTemplateOfType((FileType)StdFileTypes.JAVA)) {
                return 1;
            }
            int i2 = template1.getExtension().compareTo(template2.getExtension());
            if (i2 != 0) {
                return i2;
            }
            return template1.getName().compareTo(template2.getName());
        });
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (FileTemplate template : templates) {
            if (!CreateFromTemplateGroup.canCreateFromTemplate(e2, template)) continue;
            AnAction action2 = CreateFromTemplateGroup.replaceAction(template);
            if (action2 == null) {
                action2 = new CreateFromTemplateAction(template);
            }
            result2.add(action2);
        }
        if (!result2.isEmpty() || !showAll) {
            if (!showAll) {
                result2.add((Object)new CreateFromTemplatesAction(IdeBundle.message((String)"action.from.file.template", (Object[])new Object[0])));
            }
            result2.add(Separator.getInstance());
            result2.add((Object)new EditFileTemplatesAction(IdeBundle.message((String)"action.edit.file.templates", (Object[])new Object[0])));
        }
        AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/actions/CreateFromTemplateGroup", "getChildren"));
        }
        return anActionArray;
    }

    private static AnAction replaceAction(FileTemplate template) {
        CreateFromTemplateActionReplacer[] actionFactories;
        for (CreateFromTemplateActionReplacer actionFactory : actionFactories = (CreateFromTemplateActionReplacer[])ApplicationManager.getApplication().getExtensions(CreateFromTemplateActionReplacer.CREATE_FROM_TEMPLATE_REPLACER)) {
            AnAction action2 = actionFactory.replaceCreateFromFileTemplateAction(template);
            if (action2 == null) continue;
            return action2;
        }
        return null;
    }

    static boolean canCreateFromTemplate(AnActionEvent e2, FileTemplate template) {
        if (e2 == null) {
            return false;
        }
        DataContext dataContext = e2.getDataContext();
        IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view2 == null) {
            return false;
        }
        PsiDirectory[] dirs = view2.getDirectories();
        if (dirs.length == 0) {
            return false;
        }
        return FileTemplateUtil.canCreateFromTemplate(dirs, template);
    }

    private static class CreateFromTemplatesAction
    extends CreateFromTemplateActionBase {
        public CreateFromTemplatesAction(String title) {
            super(title, null, null);
        }

        @Override
        protected AnAction getReplacedAction(FileTemplate template) {
            return CreateFromTemplateGroup.replaceAction(template);
        }

        @Override
        protected FileTemplate getTemplate(Project project2, PsiDirectory dir) {
            SelectTemplateDialog dialog2 = new SelectTemplateDialog(project2, dir);
            dialog2.show();
            return dialog2.getSelectedTemplate();
        }
    }
}

