/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTemplateBase
implements FileTemplate {
    public static final boolean DEFAULT_REFORMAT_CODE_VALUE = true;
    public static final boolean DEFAULT_ENABLED_VALUE = true;
    @Nullable
    private String myText;
    private boolean myShouldReformatCode = true;
    private boolean myLiveTemplateEnabled;

    @Override
    public final boolean isReformatCode() {
        return this.myShouldReformatCode;
    }

    @Override
    public final void setReformatCode(boolean reformat) {
        this.myShouldReformatCode = reformat;
    }

    public final String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    public static String getQualifiedName(String name, String extension) {
        return FTManager.encodeFileName(name, extension);
    }

    @Override
    @NotNull
    public final String getText() {
        String text2 = this.myText;
        String string2 = text2 != null ? text2 : this.getDefaultText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "getText"));
        }
        return string2;
    }

    @Override
    public final void setText(@Nullable String text2) {
        String converted;
        this.myText = text2 == null ? null : ((converted = StringUtil.convertLineSeparators((String)text2)).equals(this.getDefaultText()) ? null : converted);
    }

    @NotNull
    protected String getDefaultText() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "getDefaultText"));
        }
        return "";
    }

    @Override
    @NotNull
    public final String getText(Map attributes) throws IOException {
        String string2 = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "getText"));
        }
        return string2;
    }

    @Override
    @NotNull
    public final String getText(Properties attributes) throws IOException {
        String string2 = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "getText"));
        }
        return string2;
    }

    @Override
    @NotNull
    public final String[] getUnsetAttributes(@NotNull Properties properties, Project project2) throws ParseException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "getUnsetAttributes"));
        }
        String[] stringArray = FileTemplateUtil.calculateAttributes(this.getText(), properties, false, project2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "getUnsetAttributes"));
        }
        return stringArray;
    }

    @Override
    public FileTemplateBase clone() {
        try {
            return (FileTemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean isTemplateOfType(@NotNull FileType fType) {
        if (fType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fType", "com/intellij/ide/fileTemplates/impl/FileTemplateBase", "isTemplateOfType"));
        }
        return fType.equals(FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.getExtension()));
    }

    @Override
    public boolean isLiveTemplateEnabled() {
        return this.myLiveTemplateEnabled;
    }

    @Override
    public void setLiveTemplateEnabled(boolean value2) {
        this.myLiveTemplateEnabled = value2;
    }

    public boolean isLiveTemplateEnabledByDefault() {
        return false;
    }
}

