/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageCallHierarchy;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String CALLEE_TYPE = IdeBundle.message((String)"title.hierarchy.callees.of", (Object[])new Object[0]);
    public static final String CALLER_TYPE = IdeBundle.message((String)"title.hierarchy.callers.of", (Object[])new Object[0]);
    private static final String CALL_HIERARCHY_BROWSER_DATA_KEY = "com.intellij.ide.hierarchy.CallHierarchyBrowserBase";

    public CallHierarchyBrowserBase(@NotNull Project project2, @NotNull PsiElement method2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "<init>"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "<init>"));
        }
        super(project2, method2);
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        if (CALL_HIERARCHY_BROWSER_DATA_KEY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "getBrowserDataKey"));
        }
        return CALL_HIERARCHY_BROWSER_DATA_KEY;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "prependActions"));
        }
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), AllIcons.Hierarchy.Caller, CALLER_TYPE));
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), AllIcons.Hierarchy.Callee, CALLEE_TYPE));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction(this));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(this));
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        if ("CallHierarchyViewToolbar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "getActionPlace"));
        }
        return "CallHierarchyViewToolbar";
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string2 = IdeBundle.message((String)"hierarchy.call.prev.occurence.name", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "getPrevOccurenceActionNameImpl"));
        }
        return string2;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string2 = IdeBundle.message((String)"hierarchy.call.next.occurence.name", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase", "getNextOccurenceActionNameImpl"));
        }
        return string2;
    }

    protected static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.message((String)"action.base.on.this.method", (Object[])new Object[0]), CallHierarchyBrowserBase.CALL_HIERARCHY_BROWSER_DATA_KEY, (LanguageExtension<HierarchyProvider>)LanguageCallHierarchy.INSTANCE);
        }
    }

    private class ChangeViewTypeActionBase
    extends ToggleAction {
        private final String myTypeName;

        private ChangeViewTypeActionBase(String shortDescription, String longDescription, Icon icon, String typeName) {
            super(shortDescription, longDescription, icon);
            this.myTypeName = typeName;
        }

        public final boolean isSelected(AnActionEvent event) {
            return this.myTypeName.equals(CallHierarchyBrowserBase.this.getCurrentViewType());
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (flag) {
                ApplicationManager.getApplication().invokeLater(() -> CallHierarchyBrowserBase.this.changeView(this.myTypeName));
            }
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/hierarchy/CallHierarchyBrowserBase$ChangeViewTypeActionBase", "update"));
            }
            super.update(event);
            CallHierarchyBrowserBase.this.setEnabled(CallHierarchyBrowserBase.this.isValidBase());
        }
    }
}

