/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseHierarchyActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase");
    private final LanguageExtension<HierarchyProvider> myExtension;

    protected BrowseHierarchyActionBase(@NotNull LanguageExtension<HierarchyProvider> extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "<init>"));
        }
        this.myExtension = extension;
    }

    public final void actionPerformed(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        HierarchyProvider provider = this.getProvider(e2);
        if (provider == null) {
            return;
        }
        PsiElement target = provider.getTarget(dataContext);
        if (target == null) {
            return;
        }
        BrowseHierarchyActionBase.createAndAddToPanel(project2, provider, target);
    }

    @NotNull
    public static HierarchyBrowser createAndAddToPanel(@NotNull Project project2, @NotNull HierarchyProvider provider, @NotNull PsiElement target) {
        Content content2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "createAndAddToPanel"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "createAndAddToPanel"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "createAndAddToPanel"));
        }
        HierarchyBrowser hierarchyBrowser = provider.createHierarchyBrowser(target);
        HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(project2);
        ContentManager contentManager = hierarchyBrowserManager.getContentManager();
        Content selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null && !selectedContent.isPinned()) {
            content2 = selectedContent;
            JComponent component = content2.getComponent();
            if (component instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)component));
            }
            content2.setComponent(hierarchyBrowser.getComponent());
        } else {
            content2 = ContentFactory.SERVICE.getInstance().createContent(hierarchyBrowser.getComponent(), null, true);
            contentManager.addContent(content2);
        }
        contentManager.setSelectedContent(content2);
        hierarchyBrowser.setContent(content2);
        Runnable runnable2 = () -> {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "lambda$createAndAddToPanel$0"));
            }
            if (hierarchyBrowser instanceof HierarchyBrowserBase && ((HierarchyBrowserBase)hierarchyBrowser).isDisposed()) {
                return;
            }
            provider.browserActivated(hierarchyBrowser);
        };
        ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.HIERARCHY).activate(runnable2);
        HierarchyBrowser hierarchyBrowser2 = hierarchyBrowser;
        if (hierarchyBrowser2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "createAndAddToPanel"));
        }
        return hierarchyBrowser2;
    }

    public void update(AnActionEvent e2) {
        if (!this.myExtension.hasAnyExtensions()) {
            e2.getPresentation().setVisible(false);
        } else {
            boolean enabled = this.isEnabled(e2);
            if (ActionPlaces.isPopupPlace((String)e2.getPlace())) {
                e2.getPresentation().setVisible(enabled);
            } else {
                e2.getPresentation().setVisible(true);
            }
            e2.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(AnActionEvent e2) {
        HierarchyProvider provider = this.getProvider(e2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using provider " + provider);
        }
        if (provider == null) {
            return false;
        }
        PsiElement target = provider.getTarget(e2.getDataContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target: " + target);
        }
        return target != null;
    }

    @Nullable
    private HierarchyProvider getProvider(AnActionEvent e2) {
        return BrowseHierarchyActionBase.findProvider(this.myExtension, (PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT), (PsiFile)e2.getData(CommonDataKeys.PSI_FILE), e2.getDataContext());
    }

    @Nullable
    public static HierarchyProvider findProvider(@NotNull LanguageExtension<HierarchyProvider> extension, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile, @NotNull DataContext dataContext) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "findProvider"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase", "findProvider"));
        }
        HierarchyProvider provider = BrowseHierarchyActionBase.findBestHierarchyProvider(extension, psiElement, dataContext);
        if (provider == null) {
            return BrowseHierarchyActionBase.findBestHierarchyProvider(extension, (PsiElement)psiFile, dataContext);
        }
        return provider;
    }

    @Nullable
    public static HierarchyProvider findBestHierarchyProvider(LanguageExtension<HierarchyProvider> extension, @Nullable PsiElement element, DataContext dataContext) {
        if (element == null) {
            return null;
        }
        List providers = extension.allForLanguage(element.getLanguage());
        for (HierarchyProvider provider : providers) {
            PsiElement target = provider.getTarget(dataContext);
            if (target == null) continue;
            return provider;
        }
        return (HierarchyProvider)ContainerUtil.getFirstItem((List)providers);
    }
}

