/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import com.intellij.xml.util.HtmlUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileType
extends XmlLikeFileType {
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".html";
    public static final HtmlFileType INSTANCE = new HtmlFileType();

    private HtmlFileType() {
        super((Language)HTMLLanguage.INSTANCE);
    }

    HtmlFileType(Language language) {
        super(language);
    }

    @NotNull
    public String getName() {
        if ("HTML" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HtmlFileType", "getName"));
        }
        return "HTML";
    }

    @NotNull
    public String getDescription() {
        String string2 = IdeBundle.message((String)"filetype.description.html", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HtmlFileType", "getDescription"));
        }
        return string2;
    }

    @NotNull
    public String getDefaultExtension() {
        if ("html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/HtmlFileType", "getDefaultExtension"));
        }
        return "html";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Html;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content2) {
        String strContent;
        String charset;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/highlighter/HtmlFileType", "getCharset"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/highlighter/HtmlFileType", "getCharset"));
        }
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(file2, content2, content2.length);
        String string2 = charset = guessed != null && guessed.first != null ? ((Charset)guessed.first).name() : XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content2);
        if (charset != null) {
            return charset;
        }
        try {
            strContent = new String(content2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
        Charset c2 = HtmlUtil.detectCharsetFromMetaTag(strContent);
        return c2 == null ? null : c2.name();
    }

    @Override
    public Charset extractCharsetFromFileContent(@Nullable Project project2, @Nullable VirtualFile file2, @NotNull CharSequence content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/highlighter/HtmlFileType", "extractCharsetFromFileContent"));
        }
        String name = XmlCharsetDetector.extractXmlEncodingFromProlog((CharSequence)content2);
        Charset charset = CharsetToolkit.forName((String)name);
        if (charset != null) {
            return charset;
        }
        return HtmlUtil.detectCharsetFromMetaTag(content2);
    }
}

