/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.HexNumberParser;
import com.intellij.ide.highlighter.custom.tokens.IdentifierParser;
import com.intellij.ide.highlighter.custom.tokens.KeywordParser;
import com.intellij.ide.highlighter.custom.tokens.LineCommentParser;
import com.intellij.ide.highlighter.custom.tokens.MultilineCommentParser;
import com.intellij.ide.highlighter.custom.tokens.NumberParser;
import com.intellij.ide.highlighter.custom.tokens.PunctuationParser;
import com.intellij.ide.highlighter.custom.tokens.QuotedStringParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.ide.highlighter.custom.tokens.WhitespaceParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CustomHighlighterTokenType;
import java.util.ArrayList;
import java.util.List;

public final class CustomFileTypeLexer
extends AbstractCustomLexer {
    public CustomFileTypeLexer(SyntaxTable table2, boolean forHighlighting) {
        super(CustomFileTypeLexer.buildTokenParsers(table2, forHighlighting));
    }

    public CustomFileTypeLexer(SyntaxTable table2) {
        this(table2, false);
    }

    private static List<TokenParser> buildTokenParsers(SyntaxTable table2, boolean forHighlighting) {
        LineCommentParser lineCommentParser = StringUtil.isEmpty((String)table2.getLineComment()) ? null : new LineCommentParser(table2.getLineComment(), table2.lineCommentOnlyAtStart);
        MultilineCommentParser multilineCommentParser = MultilineCommentParser.create(table2.getStartComment(), table2.getEndComment());
        NumberParser numberParser = new NumberParser(table2.getNumPostfixChars(), table2.isIgnoreCase());
        HexNumberParser hexNumberParser = HexNumberParser.create(table2.getHexPrefix());
        final KeywordParser parser = table2.getKeywordParser();
        TokenParser keywordParser2 = new TokenParser(){

            @Override
            public boolean hasToken(int position) {
                return parser.hasToken(position, this.myBuffer, this.myTokenInfo);
            }
        };
        IdentifierParser identifierParser = new IdentifierParser(parser);
        QuotedStringParser quotedStringParser = new QuotedStringParser("\"", CustomHighlighterTokenType.STRING, table2.isHasStringEscapes());
        QuotedStringParser quotedStringParser2 = new QuotedStringParser("'", forHighlighting ? CustomHighlighterTokenType.SINGLE_QUOTED_STRING : CustomHighlighterTokenType.STRING, table2.isHasStringEscapes());
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>();
        tokenParsers.add(new WhitespaceParser());
        if (lineCommentParser != null) {
            tokenParsers.add(lineCommentParser);
        }
        if (multilineCommentParser != null) {
            tokenParsers.add(multilineCommentParser);
        }
        tokenParsers.add(quotedStringParser);
        tokenParsers.add(quotedStringParser2);
        tokenParsers.add(new PunctuationParser());
        if (hexNumberParser != null) {
            tokenParsers.add(hexNumberParser);
        }
        tokenParsers.add(numberParser);
        tokenParsers.add(keywordParser2);
        tokenParsers.add(identifierParser);
        if (table2.isHasBraces()) {
            tokenParsers.addAll(BraceTokenParser.getBraces());
        }
        if (table2.isHasParens()) {
            tokenParsers.addAll(BraceTokenParser.getParens());
        }
        if (table2.isHasBrackets()) {
            tokenParsers.addAll(BraceTokenParser.getBrackets());
        }
        return tokenParsers;
    }
}

