/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.ide.highlighter.custom.CustomFileHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeFoldingBuilder
extends CustomFoldingBuilder {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "buildLanguageFoldRegions"));
        }
        FileType fileType = root.getContainingFile().getFileType();
        if (!(fileType instanceof CustomSyntaxTableFileType)) {
            return;
        }
        CustomFileHighlighter highlighter2 = new CustomFileHighlighter(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
        CustomFileTypeFoldingBuilder.buildBraceMatcherBasedFolding(descriptors, root, document, (SyntaxHighlighter)highlighter2);
    }

    public static void buildBraceMatcherBasedFolding(List<FoldingDescriptor> descriptors, PsiElement root, Document document, SyntaxHighlighter highlighter2) {
        LexerEditorHighlighter editorHighlighter = new LexerEditorHighlighter(highlighter2, EditorColorsManager.getInstance().getGlobalScheme());
        editorHighlighter.setText(document.getText());
        FileType fileType = root.getContainingFile().getFileType();
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, root.getLanguage());
        TextRange totalRange = root.getTextRange();
        HighlighterIterator iterator2 = editorHighlighter.createIterator(totalRange.getStartOffset());
        LinkedList<Trinity> stack = new LinkedList<Trinity>();
        String editorText = document.getText();
        while (!iterator2.atEnd() && iterator2.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator2, editorText, fileType) && braceMatcher.isStructuralBrace(iterator2, editorText, fileType)) {
                stack.addLast(Trinity.create((Object)iterator2.getStart(), (Object)iterator2.getEnd(), (Object)iterator2.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator2, editorText, fileType) && braceMatcher.isStructuralBrace(iterator2, editorText, fileType) && !stack.isEmpty()) {
                Trinity last = (Trinity)stack.getLast();
                if (braceMatcher.isPairBraces((IElementType)last.third, iterator2.getTokenType())) {
                    stack.removeLast();
                    TextRange range = new TextRange(((Integer)last.first).intValue(), iterator2.getEnd());
                    if (StringUtil.countChars((CharSequence)document.getText(range), (char)'\n') >= 3) {
                        descriptors.add(new FoldingDescriptor(root, range));
                    }
                }
            }
            iterator2.advance();
        }
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "getLanguagePlaceholderText"));
        }
        return "{...}";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        return false;
    }
}

