/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.editorActions.BraceMatcherBasedSelectioner;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeQuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class CustomFileTypeSelectWordHandler
extends BraceMatcherBasedSelectioner {
    @Override
    public boolean canSelect(PsiElement e2) {
        return e2.getContainingFile().getFileType() instanceof CustomSyntaxTableFileType;
    }

    @Override
    public List<TextRange> select(PsiElement e2, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> superResult = super.select(e2, editorText, cursorOffset, editor);
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(cursorOffset);
        if (CustomFileTypeQuoteHandler.isQuotedToken(iterator2.getTokenType())) {
            ArrayList result2 = ContainerUtil.newArrayList();
            int start2 = iterator2.getStart();
            int end = iterator2.getEnd();
            if (end - start2 > 2) {
                result2.add(new TextRange(start2 + 1, end - 1));
            }
            result2.add(new TextRange(start2, end));
            if (superResult != null) {
                result2.addAll(superResult);
            }
            return result2;
        }
        return superResult;
    }
}

