/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.ide.highlighter.FileTypeRegistrator;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeBraceMatcher;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeQuoteHandler;
import com.intellij.lang.Commenter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;

public class StandardFileTypeRegistrator
implements FileTypeRegistrator {
    public void initFileType(FileType fileType) {
        if (fileType instanceof AbstractFileType) {
            StandardFileTypeRegistrator.init((AbstractFileType)fileType);
        }
    }

    private static void init(AbstractFileType abstractFileType) {
        SyntaxTable table2 = abstractFileType.getSyntaxTable();
        if (!StandardFileTypeRegistrator.isEmpty(table2.getStartComment()) && !StandardFileTypeRegistrator.isEmpty(table2.getEndComment()) || !StandardFileTypeRegistrator.isEmpty(table2.getLineComment())) {
            abstractFileType.setCommenter(new MyCommenter(abstractFileType));
        }
        if (table2.isHasBraces() || table2.isHasBrackets() || table2.isHasParens()) {
            BraceMatchingUtil.registerBraceMatcher(abstractFileType, CustomFileTypeBraceMatcher.createBraceMatcher());
        }
        TypedHandler.registerQuoteHandler(abstractFileType, new CustomFileTypeQuoteHandler());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static class MyCommenter
    implements Commenter {
        private final CustomSyntaxTableFileType myAbstractFileType;

        public MyCommenter(CustomSyntaxTableFileType abstractFileType) {
            this.myAbstractFileType = abstractFileType;
        }

        public String getLineCommentPrefix() {
            return this.myAbstractFileType.getSyntaxTable().getLineComment();
        }

        public String getBlockCommentPrefix() {
            return this.myAbstractFileType.getSyntaxTable().getStartComment();
        }

        public String getBlockCommentSuffix() {
            return this.myAbstractFileType.getSyntaxTable().getEndComment();
        }

        public String getCommentedBlockCommentPrefix() {
            return null;
        }

        public String getCommentedBlockCommentSuffix() {
            return null;
        }
    }
}

