/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ContentManagerWatcher {
    private final ToolWindow myToolWindow;
    private final ContentManager myContentManager;
    private final PropertyChangeListener myPropertyChangeListener;

    public ContentManagerWatcher(ToolWindow toolWindow, ContentManager contentManager) {
        this.myToolWindow = toolWindow;
        this.myContentManager = contentManager;
        this.myToolWindow.setAvailable(contentManager.getContentCount() > 0, null);
        this.myPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
            }
        };
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent e2) {
                e2.getContent().addPropertyChangeListener(ContentManagerWatcher.this.myPropertyChangeListener);
                ContentManagerWatcher.this.myToolWindow.setAvailable(true, null);
            }

            public void contentRemoved(ContentManagerEvent e2) {
                e2.getContent().removePropertyChangeListener(ContentManagerWatcher.this.myPropertyChangeListener);
                ContentManagerWatcher.this.myToolWindow.setAvailable(ContentManagerWatcher.this.myContentManager.getContentCount() > 0, null);
            }
        });
        for (int i2 = 0; i2 < this.myContentManager.getContentCount(); ++i2) {
            Content content2 = this.myContentManager.getContent(i2);
            content2.addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }
}

