/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ProjectUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.ProjectUtil");

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(String projectFilePath) {
        File lastProjectLocation = new File(projectFilePath);
        if (lastProjectLocation.isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path = lastProjectLocation.getPath();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e2) {
            LOG.info((Throwable)e2);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(path.replace(File.separatorChar, '/'));
    }

    public static boolean closeAndDispose(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectUtil", "closeAndDispose"));
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project2);
    }

    @Nullable
    public static Project openOrImport(@NotNull String path, Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor provider;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "openOrImport"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        virtualFile.refresh(false, false);
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        ProjectOpenProcessor strong = ProjectOpenProcessor.getStrongImportProvider((VirtualFile)virtualFile);
        if (strong != null) {
            return strong.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        }
        if (ProjectKt.isValidProjectPath(path)) {
            return ProjectUtil.openProject(path, projectToClose, forceOpenInNewFrame);
        }
        if (virtualFile.isDirectory()) {
            for (VirtualFile child : virtualFile.getChildren()) {
                String childPath = child.getPath();
                if (!childPath.endsWith(".ipr")) continue;
                return ProjectUtil.openProject(childPath, projectToClose, forceOpenInNewFrame);
            }
        }
        if ((provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) != null) {
            Project project2 = provider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
            if (project2 != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ToolWindow toolWindow;
                    if (!project2.isDisposed() && (toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.PROJECT_VIEW)) != null) {
                        toolWindow.activate(null);
                    }
                }, ModalityState.NON_MODAL);
            }
            return project2;
        }
        return null;
    }

    @Nullable
    public static Project openProject(String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        File dir;
        File file2 = new File(path);
        if (!file2.exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{path}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        if (file2.isDirectory() && !(dir = new File(file2, ".idea")).exists()) {
            String message2 = IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{dir.getPath()});
            Messages.showErrorDialog((String)message2, (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1) {
                Project toClose;
                Project project2 = toClose = projectToClose != null ? projectToClose : openProjects[openProjects.length - 1];
                if (!ProjectUtil.closeAndDispose(toClose)) {
                    return null;
                }
            } else if (exitCode != 0) {
                return null;
            }
        }
        if (ProjectUtil.isRemotePath(path) && !RecentProjectsManager.getInstance().hasPath(path) && !ProjectUtil.confirmLoadingFromRemotePath(path, "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project3 = null;
        try {
            project3 = projectManager.loadAndOpenProject(path);
        }
        catch (IOException e2) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e2.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidDataException | JDOMException e3) {
            LOG.info(e3);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return project3;
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "confirmLoadingFromRemotePath"));
        }
        if (msgKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgKey", "com/intellij/ide/impl/ProjectUtil", "confirmLoadingFromRemotePath"));
        }
        if (titleKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleKey", "com/intellij/ide/impl/ProjectUtil", "confirmLoadingFromRemotePath"));
        }
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull String message2, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/ide/impl/ProjectUtil", "showYesNoDialog"));
        }
        if (titleKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleKey", "com/intellij/ide/impl/ProjectUtil", "showYesNoDialog"));
        }
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        Icon icon = Messages.getWarningIcon();
        String title = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
        int answer = window == null ? Messages.showYesNoDialog((String)message2, (String)title, (Icon)icon) : Messages.showYesNoDialog((Component)window, (String)message2, (String)title, (Icon)icon);
        return answer == 0;
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "isRemotePath"));
        }
        return path.contains("://") || path.contains("\\\\");
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(String path) {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (project2.isDefault() || !ProjectUtil.isSameProject(path, project2)) continue;
            ProjectUtil.focusProjectWindow(project2, false);
            return project2;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n2 = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectUtil", "isSameProject"));
        }
        if (projectFilePath == null) {
            return false;
        }
        IProjectStore projectStore = ProjectKt.getStateStore(project2);
        String existingBaseDirPath = projectStore.getProjectBasePath();
        if (existingBaseDirPath == null) {
            return false;
        }
        File projectFile = new File(projectFilePath);
        if (projectFile.isDirectory()) {
            return FileUtil.pathsEqual((String)projectFilePath, (String)existingBaseDirPath);
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            return FileUtil.pathsEqual((String)projectFilePath, (String)projectStore.getProjectFilePath());
        }
        File parent = projectFile.getParentFile();
        if (parent.getName().equals(".idea")) {
            return (parent = parent.getParentFile()) != null && FileUtil.pathsEqual((String)parent.getPath(), (String)existingBaseDirPath);
        }
        return FileUtil.pathsEqual((String)parent.getPath(), (String)existingBaseDirPath) && "ipr".equals(FileUtilRt.getExtension((String)projectFile.getName()));
    }

    public static void focusProjectWindow(final Project p2, boolean executeIfAppInactive) {
        FocusCommand cmd = new FocusCommand(){

            @NotNull
            public ActionCallback run() {
                JFrame f2 = WindowManager.getInstance().getFrame(p2);
                if (f2 != null) {
                    f2.toFront();
                }
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectUtil$1", "run"));
                }
                return actionCallback;
            }
        };
        if (executeIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)WindowManager.getInstance().getFrame(p2));
            cmd.run();
        } else {
            IdeFocusManager.getInstance((Project)p2).requestFocus(cmd, true);
        }
    }

    public static String getBaseDir() {
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        if (PlatformUtils.isCLion()) {
            productName = ApplicationNamesInfo.getInstance().getProductName();
        }
        return userHome.replace('/', File.separatorChar) + File.separator + productName + "Projects";
    }
}

