/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectInTargetPsiWrapper
implements SelectInTarget {
    protected final Project myProject;

    protected SelectInTargetPsiWrapper(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "<init>"));
        }
        this.myProject = project2;
    }

    public abstract String toString();

    protected abstract boolean canSelect(PsiFileSystemItem var1);

    public final boolean canSelect(@NotNull SelectInContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "canSelect"));
        }
        if (!this.isContextValid(context2)) {
            return false;
        }
        return this.canWorkWithCustomObjects() || this.canSelectInner(context2);
    }

    protected boolean canSelectInner(@NotNull SelectInContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "canSelectInner"));
        }
        PsiFileSystemItem psiFile = this.getContextPsiFile(context2);
        return psiFile != null && this.canSelect(psiFile);
    }

    private boolean isContextValid(SelectInContext context2) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = context2.getVirtualFile();
        return virtualFile.isValid();
    }

    @Nullable
    protected PsiFileSystemItem getContextPsiFile(@NotNull SelectInContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "getContextPsiFile"));
        }
        VirtualFile virtualFile = context2.getVirtualFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        if (psiFile != null) {
            return psiFile;
        }
        if (context2.getSelectorInFile() instanceof PsiFile) {
            return (PsiFile)context2.getSelectorInFile();
        }
        if (virtualFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile);
        }
        return null;
    }

    public final void selectIn(@NotNull SelectInContext context2, boolean requestFocus2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "selectIn"));
        }
        VirtualFile file2 = context2.getVirtualFile();
        Object selector = context2.getSelectorInFile();
        if (selector == null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Object object = selector = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
        }
        if (selector instanceof PsiElement) {
            this.select(((PsiElement)selector).getOriginalElement(), requestFocus2);
        } else {
            this.select(selector, file2, requestFocus2);
        }
    }

    protected abstract void select(Object var1, VirtualFile var2, boolean var3);

    protected abstract boolean canWorkWithCustomObjects();

    protected abstract void select(PsiElement var1, boolean var2);

    @Nullable
    protected static PsiElement findElementToSelect(PsiElement element, PsiElement candidate) {
        PsiElement toSelect = candidate;
        if (toSelect == null) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) {
                toSelect = element;
            } else {
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null) {
                    FileViewProvider viewProvider = containingFile.getViewProvider();
                    toSelect = viewProvider.getPsi(viewProvider.getBaseLanguage());
                }
            }
        }
        if (toSelect != null) {
            PsiElement originalElement = null;
            try {
                originalElement = toSelect.getOriginalElement();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (originalElement != null) {
                toSelect = originalElement;
            }
        }
        return toSelect;
    }
}

