/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license;

import com.intellij.ide.license.LicenseEntry;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.BuiltInEvaluationSource;
import com.intellij.ide.license.impl.FileLicenseSource;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.ide.license.impl.LicenseServerSource;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationNamesInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneralLicenseEntry
implements LicenseEntry {
    private LicenseSource[] sources;
    private LicenseSource actual;
    private LicenseFactory factory;
    @Nullable
    private final String problemDescription;
    private LicenseSourceFinder<FileLicenseSource> fileSourceFinder = new LicenseSourceFinder<FileLicenseSource>(){

        @Override
        boolean isAccepted(@NotNull LicenseSource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/license/GeneralLicenseEntry$1", "isAccepted"));
            }
            return source instanceof FileLicenseSource;
        }
    };
    private LicenseSourceFinder<LicenseServerSource> lsFinder = new LicenseSourceFinder<LicenseServerSource>(){

        @Override
        boolean isAccepted(@NotNull LicenseSource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/license/GeneralLicenseEntry$2", "isAccepted"));
            }
            return source instanceof LicenseServerSource;
        }
    };
    private LicenseSourceFinder<JetprofileSource> serviceFinder = new LicenseSourceFinder<JetprofileSource>(){

        @Override
        boolean isAccepted(@NotNull LicenseSource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/license/GeneralLicenseEntry$3", "isAccepted"));
            }
            return source instanceof JetprofileSource;
        }
    };
    private LicenseSourceFinder<BuiltInEvaluationSource> buildInFinder = new LicenseSourceFinder<BuiltInEvaluationSource>(){

        @Override
        boolean isAccepted(@NotNull LicenseSource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/license/GeneralLicenseEntry$4", "isAccepted"));
            }
            return source instanceof BuiltInEvaluationSource;
        }
    };

    public GeneralLicenseEntry(LicenseSource[] sources, LicenseSource actual, LicenseFactory factory2) {
        this(sources, actual, factory2, null);
    }

    public GeneralLicenseEntry(LicenseSource[] sources, LicenseSource actual, LicenseFactory factory2, @Nullable String problemDescription) {
        this.sources = sources;
        this.actual = actual;
        this.factory = factory2;
        this.problemDescription = problemDescription;
    }

    @Override
    @Nullable
    public String getInitialProblemDescription() {
        return this.problemDescription;
    }

    @Override
    public LicenseSource getActualLicenseSource() {
        return this.actual;
    }

    @Override
    public void proceed(@NotNull LicenseSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/license/GeneralLicenseEntry", "proceed"));
        }
        this.actual = source;
    }

    @Override
    public void forgetLicense() {
        for (LicenseSource source : this.sources) {
            try {
                source.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        LicenseEntryUtil.showLicenseNotificationLater("Registration", ApplicationNamesInfo.getInstance().getFullProductName() + " license information was removed", NotificationType.INFORMATION);
    }

    @Override
    public boolean cancelMeansShutdown() {
        return false;
    }

    @Override
    public LicenseFactory getFactory() {
        return this.factory;
    }

    @Override
    @Nullable
    public FileLicenseSource getFileSource() {
        return this.fileSourceFinder.find(this.sources);
    }

    @Override
    @Nullable
    public BuiltInEvaluationSource getBuiltInEvalSource() {
        return this.buildInFinder.find(this.sources);
    }

    @Override
    @Nullable
    public LicenseServerSource getLicenseServerSource() {
        return this.lsFinder.find(this.sources);
    }

    @Override
    @Nullable
    public JetprofileSource getJetProfileSource() {
        return this.serviceFinder.find(this.sources);
    }

    @Override
    public Collection<LicenseSource> getAvailableLicenseSources() {
        LicenseSource[] _sources = this.sources;
        return _sources != null ? Arrays.asList(_sources) : Collections.emptyList();
    }

    private static class LicenseSourceFinder<T> {
        private LicenseSourceFinder() {
        }

        boolean isAccepted(@NotNull LicenseSource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/license/GeneralLicenseEntry$LicenseSourceFinder", "isAccepted"));
            }
            return true;
        }

        @Nullable
        T find(LicenseSource[] sources) {
            if (sources == null) {
                return null;
            }
            for (LicenseSource source : sources) {
                if (!this.isAccepted(source)) continue;
                return (T)source;
            }
            return null;
        }
    }
}

