/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.idea.IdeaLicenseManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LicenseManager {
    private static LicenseManager ourInstance;

    public static LicenseManager getInstance() {
        if (ourInstance == null) {
            ourInstance = new IdeaLicenseManager();
        }
        return ourInstance;
    }

    public static void setInstance(LicenseManager manager) {
        if (ourInstance == null) {
            ourInstance = manager;
        }
    }

    public abstract boolean supportsRegistration();

    public abstract void register();

    public abstract void startUp(StartupAction var1);

    public abstract String licensedToMessage();

    @NotNull
    public List<String> licensedRestrictionsMessages() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/LicenseManager", "licensedRestrictionsMessages"));
        }
        return list2;
    }

    public abstract LicenseFactory createLicenseFactory();

    public abstract LicenseFactory getLicenseFactory();

    public abstract boolean isEvaluationLicense();

    public abstract Date getEvaluationExpirationDate();

    public abstract boolean needEvaluationFollowUp();

    public boolean isEap() {
        return ApplicationInfoEx.getInstanceEx().isEAP();
    }

    public boolean isPermanentLicenseServerLicenseSupported() {
        return false;
    }

    public boolean hasPermanentLicense() {
        return false;
    }

    public void obtainPermanentLicenseFromServer() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean willLicenseExpire();

    public void releasePermanentLicense() {
        throw new UnsupportedOperationException();
    }

    public boolean needDetectCheater() {
        return this.isEvaluationLicense();
    }

    public String verifyPlugin(BigInteger key) {
        return "0";
    }

    @Nullable
    public Date getMaintenanceDueDate() {
        return null;
    }

    @Nullable
    public LicenseSource getActualSource() {
        return null;
    }

    public static class StartupAction {
        public void proceed() {
        }

        public void cancel() {
        }

        public boolean cancelMeansShutdown() {
            return false;
        }
    }
}

