/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicensingFacadeImpl
extends LicensingFacade {
    @Override
    public String getLicensedToMessage() {
        return LicenseManager.getInstance().licensedToMessage();
    }

    @Override
    public List<String> getLicenseRestrictionsMessages() {
        ArrayList<String> result2 = new ArrayList<String>();
        LicenseManager licenseManager = LicenseManager.getInstance();
        result2.addAll(licenseManager.licensedRestrictionsMessages());
        Date mdd = licenseManager.getMaintenanceDueDate();
        if (mdd != null) {
            result2.add(IdeBundle.message((String)"about.box.maintenance.due", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)mdd)}));
        }
        return result2;
    }

    @Override
    public boolean isEvaluationLicense() {
        return LicenseManager.getInstance().isEvaluationLicense();
    }

    @Override
    public Boolean isApplicableForProduct(@NotNull Date productBuildDate) {
        CertKeyLicense certKeyLicense;
        CertKey certKey;
        LicenseData license;
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/LicensingFacadeImpl", "isApplicableForProduct"));
        }
        LicenseSource source = LicenseManager.getInstance().getActualSource();
        if (source != null && (license = source.getLicense()) instanceof CertKeyLicense && (certKey = (certKeyLicense = (CertKeyLicense)((Object)license)).getCertKey()) != null) {
            return certKey.isApplicableTo(new Date(), certKeyLicense.getProductCode(), productBuildDate);
        }
        return null;
    }

    @Override
    public Boolean isPerpetualForProduct(@NotNull Date productBuildDate) {
        CertKeyLicense certKeyLicense;
        CertKey certKey;
        LicenseData license;
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/LicensingFacadeImpl", "isPerpetualForProduct"));
        }
        LicenseSource source = LicenseManager.getInstance().getActualSource();
        if (source != null && (license = source.getLicense()) instanceof CertKeyLicense && (certKey = (certKeyLicense = (CertKeyLicense)((Object)license)).getCertKey()) != null) {
            return certKey.isPerpetualForProduct(certKeyLicense.getProductCode(), productBuildDate);
        }
        return null;
    }

    @Override
    @Nullable
    public Date getLicenseExpirationDate() {
        LicenseData license;
        LicenseSource source = LicenseManager.getInstance().getActualSource();
        if (source != null && (license = source.getLicense()) != null) {
            return license.getExpirationDate();
        }
        return null;
    }
}

