/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license;

import com.jetbrains.licenseServer.Products;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ProductDescriptor {
    IDEA("idea", "II", Products.IDEA),
    RUBYMINE("RubyMine", "RM", Products.RUBYMINE),
    PYCHARM("PyCharm", "PC", Products.PYCHARM),
    WEBSTORM("WebStorm", "WS", Products.WEBSTORM),
    PHPSTORM("PhpStorm", "PS", Products.PHPSTORM),
    APPCODE("AppCode", "AC", Products.APPCODE),
    DATAGRIP("DataGrip", "DB", Products.DBIDE),
    CLION("CLion", "CL", Products.CLION),
    RIDER("Rider", "RD", Products.RIDER),
    GOIDE("Gogland", "GO", UUID.fromString("6ca374ac-f547-4984-be94-adb3e47b580c"));

    @NotNull
    private final String shortName;
    @NotNull
    private final String productCode;
    @NotNull
    private final UUID productFamily;

    private ProductDescriptor(@NotNull String shortName, String productCode, UUID productFamily) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/ide/license/ProductDescriptor", "<init>"));
        }
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/ProductDescriptor", "<init>"));
        }
        if (productFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productFamily", "com/intellij/ide/license/ProductDescriptor", "<init>"));
        }
        this.shortName = shortName;
        this.productCode = productCode;
        this.productFamily = productFamily;
    }

    @NotNull
    public String getShortName() {
        String string2 = this.shortName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ProductDescriptor", "getShortName"));
        }
        return string2;
    }

    @NotNull
    public String getProductCode() {
        String string2 = this.productCode;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ProductDescriptor", "getProductCode"));
        }
        return string2;
    }

    @NotNull
    public UUID getProductFamily() {
        UUID uUID = this.productFamily;
        if (uUID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/ProductDescriptor", "getProductFamily"));
        }
        return uUID;
    }

    @Nullable
    public static ProductDescriptor findByProductName(String productName) {
        if (productName != null) {
            for (ProductDescriptor descriptor2 : ProductDescriptor.values()) {
                if (!descriptor2.getShortName().equalsIgnoreCase(productName)) continue;
                return descriptor2;
            }
        }
        return null;
    }

    @Nullable
    public static ProductDescriptor findByProductCode(String productCode) {
        if (productCode != null) {
            for (ProductDescriptor descriptor2 : ProductDescriptor.values()) {
                if (!descriptor2.getProductCode().equals(productCode)) continue;
                return descriptor2;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        UUID uuid = UUID.randomUUID();
        System.out.println("uuid = " + uuid.toString());
    }
}

