/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.commandLine;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.jetbrains.ls.util.RSAEncoder;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import org.jetbrains.annotations.NonNls;

public class TeamServerIdeaLicense
extends LicenseManager {
    @NonNls
    private static final String AGENT_PORT = "idea.build.agent.port";
    private BigInteger VERIFY_PRIVATE_MOD;
    private BigInteger VERIFY_PRIVATE_EXP;

    @Override
    public boolean supportsRegistration() {
        return false;
    }

    @Override
    public void register() {
    }

    @Override
    public void startUp(LicenseManager.StartupAction action2) {
        if (TeamServerIdeaLicense.checkPort()) {
            this.VERIFY_PRIVATE_MOD = new BigInteger("ba3da866372947f737c0120610ae281f1085659726cbd2b1288ac7a2b95acef7392d4c848d4cab7767c2c972bdf4e4f73482ef23fb31bf6dda4cbcbf82924d97", 16);
            this.VERIFY_PRIVATE_EXP = new BigInteger("395af9bc98ea4eae74ede2df194df92f2ff0550c0ab7a4a8487b0ce6313d25157905b0b480f3e13b86a06e69b120ee687bbca0b93f6c512241261862a5d76f89", 16);
            action2.proceed();
        } else {
            System.out.println(IdeBundle.message((String)"team.server.license.not.found", (Object[])new Object[0]));
            action2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkPort() {
        Socket s2 = new Socket();
        try {
            int portNumber = TeamServerIdeaLicense.getPortNumber();
            if (portNumber == -1) {
                boolean bl = false;
                return bl;
            }
            s2.connect(new InetSocketAddress(TeamServerIdeaLicense.getPortNumber()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s2.close();
            }
            catch (IOException e3) {
                return false;
            }
        }
    }

    private static int getPortNumber() {
        String agentPort = System.getProperty(AGENT_PORT);
        if (agentPort != null) {
            try {
                return Integer.parseInt(agentPort);
            }
            catch (NumberFormatException e2) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public String licensedToMessage() {
        return "TeamCity";
    }

    @Override
    public LicenseFactory getLicenseFactory() {
        return null;
    }

    @Override
    public LicenseFactory createLicenseFactory() {
        return null;
    }

    @Override
    public boolean isEvaluationLicense() {
        return false;
    }

    @Override
    public Date getEvaluationExpirationDate() {
        return null;
    }

    @Override
    public boolean needEvaluationFollowUp() {
        return false;
    }

    @Override
    public boolean willLicenseExpire() {
        return false;
    }

    @Override
    public String verifyPlugin(BigInteger key) {
        BigInteger exp = this.VERIFY_PRIVATE_EXP;
        BigInteger mod = this.VERIFY_PRIVATE_MOD;
        if (exp != null && mod != null) {
            return new RSAEncoder(exp, mod).encode(key.toByteArray());
        }
        return super.verifyPlugin(key);
    }
}

