/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.common;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.ide.license.impl.ServerSource;
import com.intellij.idea.Main;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.licensecommon.license.LicenseData;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EAPUsageCollector
extends UsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        Set<UsageDescriptor> set2 = EAPUsageCollector.collectUsages();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/EAPUsageCollector", "getUsages"));
        }
        return set2;
    }

    @NotNull
    private static Set<UsageDescriptor> collectUsages() {
        block7: {
            Set<UsageDescriptor> set2;
            LicenseManager licenseManager;
            block8: {
                if (Main.isHeadless()) break block7;
                licenseManager = LicenseManager.getInstance();
                if (!licenseManager.isEap() || licenseManager.supportsRegistration() || !licenseManager.isEvaluationLicense()) break block8;
                LicenseFactory factory2 = licenseManager.getLicenseFactory();
                LicenseFile file2 = factory2.getLicenseFile();
                LicenseData license = file2.getLicense();
                if (license == null) {
                    license = JetprofileSource.loadStoredLicenseInfo(factory2);
                }
                boolean hasActivationCode = license != null && !license.isExpired(new Date());
                boolean serverLicenseObtained = !hasActivationCode && ServerSource.isServerTicketObtained(factory2.getProductDescriptor());
                HashSet<UsageDescriptor> set3 = new HashSet<UsageDescriptor>();
                set3.add(new UsageDescriptor(hasActivationCode ? "license_activation_code.YES" : "license_activation_code.NO", 1));
                set3.add(new UsageDescriptor(serverLicenseObtained ? "license_server_ticket.YES" : "license_server_ticket.NO", 1));
                HashSet<UsageDescriptor> hashSet = set3;
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/EAPUsageCollector", "collectUsages"));
                }
                return hashSet;
            }
            try {
                if (!licenseManager.supportsRegistration()) break block7;
                set2 = Collections.singleton(new UsageDescriptor(licenseManager.isEap() ? "eap.build.YES" : "eap.build.NO", 1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/EAPUsageCollector", "collectUsages"));
            }
            return set2;
        }
        Set<UsageDescriptor> set4 = Collections.emptySet();
        if (set4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/EAPUsageCollector", "collectUsages"));
        }
        return set4;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("eap.usage");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/EAPUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

