/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.common;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.common.EAPUsageCollector;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.ls.util.RSAEncoder;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class StandardEAPLicenseManager
extends LicenseManager {
    private LicenseFactory factory;
    private final int myExpirationPeriod;
    private final String myDownloadUrl;
    private final String myExpirationDescription;
    private final String myExpirationTitle;
    private final String myLicensedTo;
    private static final MessageFormat EXP_DESCRIPTION_FMT = new MessageFormat("This build of {0} has expired. Please download a new build from {1}");
    private static final MessageFormat EXP_TITLE_FMT = new MessageFormat("{0} EAP Build Expired");
    private static final MessageFormat LICENSE_TO_FMT = new MessageFormat("{0} EAP User");
    private static BigInteger VERIFY_PRIVATE_MOD;
    private static BigInteger VERIFY_PRIVATE_EXP;

    public StandardEAPLicenseManager(String productName, int expirationPeriod, String downloadUrl) {
        this.myExpirationPeriod = expirationPeriod;
        this.myDownloadUrl = downloadUrl;
        this.myExpirationDescription = EXP_DESCRIPTION_FMT.format(new Object[]{productName, downloadUrl});
        this.myExpirationTitle = EXP_TITLE_FMT.format(new Object[]{productName});
        this.myLicensedTo = LICENSE_TO_FMT.format(new Object[]{productName});
    }

    @Override
    public boolean supportsRegistration() {
        return false;
    }

    @Override
    public void register() {
    }

    @Override
    public void startUp(LicenseManager.StartupAction action2) {
        Calendar calendar = (Calendar)ApplicationInfoImpl.getShadowInstance().getBuildDate().clone();
        if (new Date().getTime() < this.getEvaluationExpirationDate().getTime() || calendar.get(1) == 2) {
            SwingUtilities.invokeLater(() -> {
                VERIFY_PRIVATE_MOD = new BigInteger("ba3da866372947f737c0120610ae281f1085659726cbd2b1288ac7a2b95acef7392d4c848d4cab7767c2c972bdf4e4f73482ef23fb31bf6dda4cbcbf82924d97", 16);
                VERIFY_PRIVATE_EXP = new BigInteger("395af9bc98ea4eae74ede2df194df92f2ff0550c0ab7a4a8487b0ce6313d25157905b0b480f3e13b86a06e69b120ee687bbca0b93f6c512241261862a5d76f89", 16);
                Extensions.getRootArea().addAvailabilityListener(UsagesCollector.EP_NAME.getName(), new ExtensionPointAvailabilityListener(){
                    private final AtomicBoolean registered = new AtomicBoolean(false);

                    public void extensionPointRegistered(ExtensionPoint extensionPoint) {
                        if (!this.registered.getAndSet(true)) {
                            extensionPoint.registerExtension((Object)new EAPUsageCollector());
                        }
                    }

                    public void extensionPointRemoved(ExtensionPoint extensionPoint) {
                    }
                });
                action2.proceed();
            });
        } else {
            int rc = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), this.myExpirationDescription, this.myExpirationTitle, -1, 1, null, new Object[]{"Download", "Shutdown"}, "Download");
            if (rc == 0) {
                BrowserUtil.browse((String)this.myDownloadUrl);
            }
            action2.cancel();
        }
    }

    @Override
    public String licensedToMessage() {
        return this.myLicensedTo;
    }

    @Override
    @NotNull
    public List<String> licensedRestrictionsMessages() {
        List<String> list2 = Collections.singletonList(IdeBundle.message((String)"message.expiration.date", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)this.getEvaluationExpirationDate())}));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/StandardEAPLicenseManager", "licensedRestrictionsMessages"));
        }
        return list2;
    }

    @Override
    public LicenseFactory getLicenseFactory() {
        if (this.factory == null) {
            this.factory = this.createLicenseFactory();
        }
        return this.factory;
    }

    @Override
    public boolean isEvaluationLicense() {
        return true;
    }

    @Override
    public Date getEvaluationExpirationDate() {
        Calendar calendar = (Calendar)ApplicationInfoImpl.getShadowInstance().getBuildDate().clone();
        calendar.add(6, this.myExpirationPeriod);
        return calendar.getTime();
    }

    @Override
    public boolean needEvaluationFollowUp() {
        return false;
    }

    @Override
    public boolean willLicenseExpire() {
        return true;
    }

    @Override
    public boolean needDetectCheater() {
        return false;
    }

    @Override
    public String verifyPlugin(BigInteger key) {
        BigInteger exp = VERIFY_PRIVATE_EXP;
        BigInteger mod = VERIFY_PRIVATE_MOD;
        if (exp != null && mod != null) {
            return new RSAEncoder(exp, mod).encode(key.toByteArray());
        }
        return super.verifyPlugin(key);
    }
}

