/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.common;

import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class StandardLicenseFile
extends LicenseFile {
    private final LicenseInfoDecoder<SubscriptionLicenseInfo> myDecoder;

    public StandardLicenseFile(ProductDescriptor productDescriptor, LicenseInfoDecoder<SubscriptionLicenseInfo> decoder, String writePath, String ... readPaths) {
        super(productDescriptor, StandardLicenseFile.findFirstExistingFile(readPaths), writePath);
        this.myDecoder = decoder;
    }

    private static String findFirstExistingFile(String[] paths) {
        for (String path : paths) {
            if (!new File(path).exists()) continue;
            return path;
        }
        return paths[paths.length - 1];
    }

    @Override
    protected void writeLicenseData(LicenseData license, OutputStream out) throws IOException {
        if (license instanceof CertKeyLicense) {
            StandardLicenseFile.writeString(out, "<certificate-key>\n");
            this.writeCertKeyLicense(license, out);
        } else {
            this.writeLegacySubscriptionLicense(license, out);
        }
    }

    @Override
    protected LicenseData parseLicenseData(String text2) {
        if (text2.startsWith("<certificate-key>\n")) {
            String key = text2.substring("<certificate-key>\n".length());
            return this.readCertKeyLicense(key);
        }
        return this.readLegacySubscriptionLicense(text2, this.myDecoder);
    }
}

