/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.common;

import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.LicenseValidator;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.common.StandardEAPLicenseManager;
import com.intellij.ide.license.common.StandardLicenseFile;
import com.intellij.ide.license.impl.CertKeyLicenseData;
import com.intellij.ide.license.impl.EvaluationLicenseData;
import com.intellij.ide.license.impl.LicenseFactoryImpl;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.ide.license.impl.SubscriptionLicenseValidator;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.license.SubscriptionLicenseDataImpl;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.SubscriptionLicenseDecoder;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class StandardSubscriptionLicenseFactory
extends LicenseFactoryImpl {
    @NotNull
    private final ProductDescriptor myProductDescriptor;
    private final int myCurrentMajorVersion;
    private final int myEvaluationPeriod;
    private final String myCurrentEvaluationSelector;
    private final boolean myForceReleaseEvaluationSelector;
    private final LicenseInfoDecoder<SubscriptionLicenseInfo> myLicenseInfoDecoder;
    private String myEvaluatorName;

    public StandardSubscriptionLicenseFactory(LicenseMessages messages, ProductDescriptor pd, int evaluationPeriod, LicenseManager licenseManager) {
        this(messages, pd, evaluationPeriod, licenseManager, new LicenseInfoDecoder<SubscriptionLicenseInfo>(){

            @Override
            public SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
                return SubscriptionLicenseDecoder.decode(key, userName);
            }
        });
    }

    public StandardSubscriptionLicenseFactory(LicenseMessages messages, ProductDescriptor pd, int evaluationPeriod, LicenseManager licenseManager, LicenseInfoDecoder<SubscriptionLicenseInfo> licenseInfoDecoder) {
        this(messages, pd, ApplicationInfoImpl.getShadowInstance().getBuild().getBaselineVersion(), evaluationPeriod, String.valueOf(ApplicationInfoImpl.getShadowInstance().getBuild().getBaselineVersion()), licenseManager, licenseInfoDecoder);
    }

    public StandardSubscriptionLicenseFactory(LicenseMessages messages, ProductDescriptor pd, int baseLineVersion, int evaluationPeriod, String currentEvaluationSelector, LicenseManager licenseManager, LicenseInfoDecoder<SubscriptionLicenseInfo> licenseInfoDecoder) {
        super(messages);
        this.myProductDescriptor = pd;
        this.myCurrentMajorVersion = StandardSubscriptionLicenseFactory.getInternalVersionNumber(baseLineVersion);
        this.myEvaluationPeriod = evaluationPeriod;
        this.myCurrentEvaluationSelector = currentEvaluationSelector;
        this.myForceReleaseEvaluationSelector = !(licenseManager instanceof StandardEAPLicenseManager);
        this.myLicenseInfoDecoder = licenseInfoDecoder;
    }

    public void setEvaluatorName(String evaluatorName) {
        this.myEvaluatorName = evaluatorName;
    }

    @Override
    public LicenseValidator getLicenseValidator() {
        return new SubscriptionLicenseValidator(ApplicationInfoImpl.getShadowInstance().getMajorReleaseBuildDate().getTime());
    }

    @Override
    public LicenseData createFromUser(String key, String userName) {
        try {
            return new CertKeyLicenseData(key, this.getProductCode(), this.getProductBuildDate());
        }
        catch (Throwable throwable) {
            return new SubscriptionLicenseDataImpl(key, userName, this.myLicenseInfoDecoder);
        }
    }

    @Override
    @NotNull
    public ProductDescriptor getProductDescriptor() {
        ProductDescriptor productDescriptor = this.myProductDescriptor;
        if (productDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/StandardSubscriptionLicenseFactory", "getProductDescriptor"));
        }
        return productDescriptor;
    }

    @NotNull
    public String getProductCode() {
        String string2 = this.getProductDescriptor().getProductCode();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/common/StandardSubscriptionLicenseFactory", "getProductCode"));
        }
        return string2;
    }

    public String getProductShortName() {
        return this.getProductDescriptor().getShortName();
    }

    @Override
    public int getCurrentMajorVersion() {
        return this.myCurrentMajorVersion;
    }

    @Override
    protected EvaluationLicenseData createEvaluationLicenseData(long date) {
        return new EvaluationLicenseData(new Date(date), this.getCurrentMajorVersion(), this.getEvaluatorName(), this.myEvaluationPeriod);
    }

    private String getEvaluatorName() {
        if (this.myEvaluatorName != null) {
            return this.myEvaluatorName;
        }
        return this.getProductShortName() + " Evaluator";
    }

    @Override
    public LicenseFile getLicenseFile() {
        String fileName = this.myProductDescriptor.getShortName().toLowerCase(Locale.US);
        String licensePath = PathManager.getConfigPath() + File.separatorChar + fileName + ".key";
        String licensePathSystem = PathManager.getSystemPath() + File.separatorChar + fileName + ".license";
        return new StandardLicenseFile(this.getProductDescriptor(), this.myLicenseInfoDecoder, licensePath, licensePathSystem, licensePath);
    }

    @Override
    public String getCurrentEvaluationSelector() {
        return this.myCurrentEvaluationSelector;
    }

    @Override
    public boolean isForceReleaseEvaluationSelector() {
        return this.myForceReleaseEvaluationSelector;
    }
}

