/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.dbe;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.common.StandardLicenseUrls;
import com.intellij.ide.license.common.StandardSubscriptionLicenseFactory;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.ui.LicenseMessagesImpl;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.util.DbeLicenseDecoder;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;

public class DbeLicenseManager
extends GeneralLicenseManager {
    private final LicenseMessages myLicenseMessages = DbeLicenseManager.createLicenseMessages(this.getEvaluationPeriod());

    @Override
    public LicenseFactory createLicenseFactory() {
        return DbeLicenseManager.createLicenseFactory(this.getMessages(), this.getEvaluationPeriod(), this);
    }

    static LicenseMessages createLicenseMessages(int evaluationPeriod) {
        return new LicenseMessagesImpl(new StandardLicenseUrls("datagrip"), evaluationPeriod).withLicenseEntryLines(7);
    }

    static StandardSubscriptionLicenseFactory createLicenseFactory(LicenseMessages messages, int evaluationPeriod, LicenseManager licenseManager) {
        return new StandardSubscriptionLicenseFactory(messages, ProductDescriptor.DATAGRIP, evaluationPeriod, licenseManager, new LicenseInfoDecoder<SubscriptionLicenseInfo>(){

            @Override
            public SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
                return DbeLicenseDecoder.decode(key, userName);
            }
        });
    }

    @Override
    protected LicenseMessages getMessages() {
        return this.myLicenseMessages;
    }
}

