/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.go;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.common.StandardLicenseUrls;
import com.intellij.ide.license.common.StandardSubscriptionLicenseFactory;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.ui.LicenseMessagesImpl;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;

public class GoIdeLicenseManager
extends GeneralLicenseManager {
    private final LicenseMessages myLicenseMessages = GoIdeLicenseManager.createLicenseMessages(this.getEvaluationPeriod());

    @Override
    public LicenseFactory createLicenseFactory() {
        return GoIdeLicenseManager.createLicenseFactory(this.getMessages(), this.getEvaluationPeriod(), this);
    }

    static LicenseMessages createLicenseMessages(int evaluationPeriod) {
        return new LicenseMessagesImpl(new StandardLicenseUrls("gogland"), evaluationPeriod).withLicenseEntryLines(7);
    }

    static StandardSubscriptionLicenseFactory createLicenseFactory(LicenseMessages messages, int evaluationPeriod, LicenseManager licenseManager) {
        return new StandardSubscriptionLicenseFactory(messages, ProductDescriptor.GOIDE, evaluationPeriod, licenseManager, (key, userName) -> {
            throw new InvalidLicenseKeyException();
        });
    }

    @Override
    protected LicenseMessages getMessages() {
        return this.myLicenseMessages;
    }
}

