/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.idea;

import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.LicenseValidator;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.common.StandardEAPLicenseManager;
import com.intellij.ide.license.idea.IdeaLicenseFile;
import com.intellij.ide.license.idea.IdeaLicenseValidator;
import com.intellij.ide.license.impl.CertKeyLicenseData;
import com.intellij.ide.license.impl.EvaluationLicenseData;
import com.intellij.ide.license.impl.LicenseFactoryImpl;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.LicenseDataImpl;
import com.intellij.licensecommon.license.SubscriptionLicenseDataImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

class IdeaLicenseFactory
extends LicenseFactoryImpl {
    private final int myCurrentMajorVersion;
    private final String myCurrentEvaluationSelector;
    private final boolean myForceReleaseEvaluationSelector;

    public IdeaLicenseFactory(LicenseMessages messages, LicenseManager licenseManager) {
        super(messages);
        int baselineVersion = ApplicationInfoImpl.getShadowInstance().getBuild().getBaselineVersion();
        this.myCurrentMajorVersion = IdeaLicenseFactory.getInternalVersionNumber(baselineVersion);
        this.myCurrentEvaluationSelector = String.valueOf(baselineVersion);
        this.myForceReleaseEvaluationSelector = !(licenseManager instanceof StandardEAPLicenseManager);
    }

    @Override
    public LicenseValidator getLicenseValidator() {
        return new IdeaLicenseValidator(this.myCurrentMajorVersion);
    }

    @Override
    protected EvaluationLicenseData createEvaluationLicenseData(long date) {
        return new EvaluationLicenseData(new Date(date), this.myCurrentMajorVersion, IdeaLicenseFactory.getAppInfo().isEAP() ? "EAP Member" : "IntelliJ IDEA Evaluator", 30);
    }

    @Override
    public int getCurrentMajorVersion() {
        return this.myCurrentMajorVersion;
    }

    @Override
    public String getCurrentEvaluationSelector() {
        return this.myCurrentEvaluationSelector;
    }

    @Override
    public boolean isForceReleaseEvaluationSelector() {
        return this.myForceReleaseEvaluationSelector;
    }

    @Override
    @NotNull
    public ProductDescriptor getProductDescriptor() {
        ProductDescriptor productDescriptor = ProductDescriptor.IDEA;
        if (productDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/idea/IdeaLicenseFactory", "getProductDescriptor"));
        }
        return productDescriptor;
    }

    @Override
    public LicenseFile getLicenseFile() {
        return new IdeaLicenseFile(this.getProductDescriptor(), 16);
    }

    @Override
    public LicenseData createFromUser(String key, String userName) {
        try {
            return new CertKeyLicenseData(key, this.getProductDescriptor().getProductCode(), this.getProductBuildDate());
        }
        catch (Throwable throwable) {
            int dashIndex = key.indexOf(45);
            if (dashIndex > 0 && key.indexOf(45, dashIndex + 1) > 0) {
                LicenseDataImpl license = new LicenseDataImpl(key, userName);
                license.setFromUser(true);
                license.setAccepted(false);
                return license;
            }
            return new SubscriptionLicenseDataImpl(key, userName, IdeaLicenseFile.IDEA_SUBSCRIPTION_LICENSE_DECODER);
        }
    }
}

