/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.idea;

import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.license.SubscriptionLicenseDataImpl;
import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.LicenseDecoder;
import com.intellij.licensecommon.util.LicenseInfo;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class IdeaLicenseFile
extends LicenseFile {
    @NonNls
    private static final String LICENSE_PATH_SYSTEM = PathManager.getSystemPath() + File.separatorChar + "idea.license";
    @NonNls
    private static final String LICENSE_PATH_BIN = PathManager.getBinPath() + File.separatorChar + "idea.license";
    public static final LicenseInfoDecoder<SubscriptionLicenseInfo> IDEA_SUBSCRIPTION_LICENSE_DECODER = new LicenseInfoDecoder<SubscriptionLicenseInfo>(){

        @Override
        public SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
            LicenseInfo info = LicenseDecoder.decodeLicenseKey(userName, key);
            if (!(info instanceof SubscriptionLicenseInfo)) {
                throw new InvalidLicenseKeyException();
            }
            return (SubscriptionLicenseInfo)info;
        }
    };

    protected IdeaLicenseFile(ProductDescriptor productDescriptor, String readPath, String writePath) {
        super(productDescriptor, readPath, writePath);
    }

    public IdeaLicenseFile(ProductDescriptor productDescriptor, int currentMajorVersion) {
        this(productDescriptor, IdeaLicenseFile.defaultReadPath(currentMajorVersion), IdeaLicenseFile.defaultWritePath());
    }

    private static String defaultReadPath(int currentMajorVersion) {
        String writePath = IdeaLicenseFile.defaultWritePath();
        if (new File(writePath).exists()) {
            return writePath;
        }
        for (int version = currentMajorVersion; version >= 4; --version) {
            String path = IdeaLicenseFile.keyPath(version);
            if (!new File(path).exists()) continue;
            return path;
        }
        if (new File(LICENSE_PATH_SYSTEM).exists()) {
            return LICENSE_PATH_SYSTEM;
        }
        return LICENSE_PATH_BIN;
    }

    private static String keyPath(int version) {
        StringBuilder path = new StringBuilder();
        path.append(PathManager.getConfigPath()).append(File.separatorChar).append("idea");
        if (version > 0) {
            path.append(version);
            if (version <= 9) {
                path.append("0");
            }
        }
        path.append(".key");
        return path.toString();
    }

    private static String defaultWritePath() {
        return IdeaLicenseFile.keyPath(-1);
    }

    @Override
    @Nullable
    protected LicenseData parseLicenseData(String text2) {
        if (text2.startsWith("<certificate-key>\n")) {
            String key = text2.substring("<certificate-key>\n".length());
            return this.readCertKeyLicense(key);
        }
        if (text2.startsWith("<subscription>\n")) {
            String license = text2.substring("<subscription>\n".length());
            return this.readLegacySubscriptionLicense(license, IDEA_SUBSCRIPTION_LICENSE_DECODER);
        }
        return this.readLegacyLicense(text2);
    }

    @Override
    protected void writeLicenseData(LicenseData license, OutputStream out) throws IOException {
        if (license instanceof CertKeyLicense) {
            IdeaLicenseFile.writeString(out, "<certificate-key>\n");
            this.writeCertKeyLicense(license, out);
        } else if (license instanceof SubscriptionLicenseDataImpl) {
            IdeaLicenseFile.writeString(out, "<subscription>\n");
            this.writeLegacySubscriptionLicense(license, out);
        } else {
            this.writeLegacyLicense(license, out);
        }
    }
}

