/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.idea;

import com.intellij.ide.license.impl.GeneralLicenseValidator;
import com.intellij.ide.license.impl.LicenseNeedUpgradeException;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.MaintenanceDueAware;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import java.util.Date;

public class IdeaLicenseValidator
extends GeneralLicenseValidator {
    private final int myCurrentMajorVersion;

    public IdeaLicenseValidator(int currentMajorVersion) {
        this.myCurrentMajorVersion = currentMajorVersion;
    }

    @Override
    protected void checkNeedUpgrade(LicenseData licenseData) throws ValidationFailedException {
        if (licenseData instanceof MaintenanceDueAware) {
            Date maintenanceDueDate = ((MaintenanceDueAware)((Object)licenseData)).getMaintenanceDueDate();
            Date buildDate = ApplicationInfoImpl.getShadowInstance().getMajorReleaseBuildDate().getTime();
            if (buildDate.getTime() > maintenanceDueDate.getTime()) {
                throw new LicenseNeedUpgradeException(maintenanceDueDate);
            }
        } else if (this.myCurrentMajorVersion > licenseData.getMajorVersion()) {
            throw new LicenseNeedUpgradeException("Specified license is valid for version " + licenseData.getMajorVersion() + " only.");
        }
    }
}

