/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.impl.GeneralLicenseSource;
import com.intellij.licensecommon.license.LicenseData;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public class BuiltInEvaluationSource
extends GeneralLicenseSource {
    private long evalPeriod;
    public static final long DAY_FACTOR = 86400000L;
    public static final long HOUR_FACTOR = 3600000L;

    public BuiltInEvaluationSource(LicenseFactory factory2, long evalPeriod) {
        super(factory2);
        this.evalPeriod = evalPeriod;
    }

    @Override
    public void create() throws LicenseCreationException {
        this.restore();
        if (this.getLicense() == null) {
            this.setLicense(this.factory.createEvaluationLicense());
        }
    }

    @Override
    public void restore() {
        LicenseData lic = this.factory.findExistingEvaluationLicense();
        this.setLicense(lic);
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean hasCachedData() {
        return false;
    }

    @Override
    public void setLicense(LicenseData license) {
        if (license != null) {
            super.setLicense(license);
        }
    }

    public long getEvalPeriod() {
        return this.evalPeriod;
    }

    @Override
    public boolean needNetworkLicenseCheck() {
        return false;
    }

    public static int remainsDays(@Nullable Date expirationDate, Date current) {
        if (expirationDate == null) {
            return -1;
        }
        return Math.max(0, (int)((expirationDate.getTime() - current.getTime() + 3600000L) / 86400000L));
    }
}

