/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.ls.data.LicenseData;
import com.jetbrains.ls.data.ProductData;
import com.jetbrains.ls.newLicenses.CertLicenseDecoder;
import com.jetbrains.ls.util.Ref;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CertKey {
    private static final int AUTO_PROLONGATION_GRACE_PERIOD_DAYS = 3;
    @NotNull
    private final Ref myKeyData;

    public CertKey(@NotNull String key) throws LicenseCreationException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/license/impl/CertKey", "<init>"));
        }
        try {
            Ref decodedData = null;
            int separatorPos = key.indexOf("-");
            if (separatorPos > 0) {
                String licenseId = key.substring(0, separatorPos);
                decodedData = ((Callable<Ref>)() -> {
                    if (key == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/license/impl/CertKey", "lambda$new$0"));
                    }
                    Class<?> builderClass = Class.forName("com.google.gson.GsonBuilder");
                    Method registerTypeAdapter = builderClass.getMethod("registerTypeAdapter", Type.class, Object.class);
                    Method create2 = builderClass.getMethod("create", new Class[0]);
                    Gson gson2 = (Gson)create2.invoke(registerTypeAdapter.invoke(builderClass.newInstance(), java.util.Date.class, new JetProfileDateAdapter()), new Object[0]);
                    Object licenseStruct = gson2.fromJson((String)Ref.deref(CertLicenseDecoder.create().decodeLicense(Ref.create(key.substring(separatorPos + 1)))), Class.forName("com.jetbrains.ls.data.LicenseData"));
                    if (licenseStruct == null || !"com.jetbrains.ls.data.LicenseData".equals(licenseStruct.getClass().getName())) {
                        return null;
                    }
                    try {
                        if (!licenseId.equals(licenseStruct.getClass().getDeclaredMethod("getLicenseId", new Class[0]).invoke(licenseStruct, new Object[0]))) {
                            return null;
                        }
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                    return Ref.create(licenseStruct);
                }).call();
            }
            if (Ref.deref(decodedData) == null) {
                throw new LicenseCreationException("Error decoding license key");
            }
            this.myKeyData = decodedData;
        }
        catch (LicenseCreationException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new LicenseCreationException("License key verification error", e3.getMessage());
        }
    }

    public String getLicenseId() {
        return ((Supplier<String>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getLicenseId()).get();
    }

    public String getLicenseeName() {
        return ((Supplier<String>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getLicenseeName()).get();
    }

    public String getAssigneeName() {
        return ((Supplier<String>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getAssigneeName()).get();
    }

    public String getAssigneeEmail() {
        return ((Supplier<String>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getAssigneeEmail()).get();
    }

    public String getLicenseRestriction() {
        return ((Supplier<String>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getLicenseRestriction()).get();
    }

    public boolean isCheckConcurrentUse() {
        return ((Supplier<Boolean>)() -> Boolean.TRUE.equals(((LicenseData)Ref.deref(this.myKeyData)).getCheckConcurrentUse())).get();
    }

    public boolean isAutoProlongated() {
        return ((Supplier<Boolean>)() -> Boolean.TRUE.equals(((LicenseData)Ref.deref(this.myKeyData)).getAutoProlongated())).get();
    }

    public String getHash() {
        return ((Supplier<String>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getHash()).get();
    }

    public int getGracePeriodDays() {
        return ((Supplier<Integer>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getGracePeriodDays()).get();
    }

    @Nullable
    public java.util.Date getExpirationDate(@NotNull String productCode) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "getExpirationDate"));
        }
        return ((Supplier<java.util.Date>)() -> {
            if (productCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "lambda$getExpirationDate$10"));
            }
            ProductData pd = this.findProductData(productCode);
            return pd == null ? null : pd.getPaidUpTo();
        }).get();
    }

    @Nullable
    public java.util.Date getFirstExpiredDate(@NotNull String productCode) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "getFirstExpiredDate"));
        }
        return ((Supplier<java.util.Date>)() -> {
            if (productCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "lambda$getFirstExpiredDate$11"));
            }
            java.util.Date expirationDate = this.getExpirationDate(productCode);
            return expirationDate == null ? null : CertKey.plusDays(expirationDate, 1);
        }).get();
    }

    @Nullable
    public java.util.Date getPerpetualFallbackDate(@NotNull String productCode) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "getPerpetualFallbackDate"));
        }
        return ((Supplier<java.util.Date>)() -> {
            if (productCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "lambda$getPerpetualFallbackDate$12"));
            }
            ProductData pd = this.findProductData(productCode);
            return pd == null ? null : pd.getFallbackDate();
        }).get();
    }

    public boolean isPerpetualForProduct(@NotNull String productCode, @NotNull java.util.Date productBuildDate) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "isPerpetualForProduct"));
        }
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/impl/CertKey", "isPerpetualForProduct"));
        }
        return ((Supplier<Boolean>)() -> {
            if (productCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "lambda$isPerpetualForProduct$13"));
            }
            if (productBuildDate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/impl/CertKey", "lambda$isPerpetualForProduct$13"));
            }
            ProductData pd = this.findProductData(productCode);
            return pd != null && CertKey.isPerpetual(pd, productBuildDate);
        }).get();
    }

    public boolean isApplicableTo(@NotNull String productCode) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "isApplicableTo"));
        }
        return this.findProductData(productCode) != null;
    }

    public boolean isApplicableTo(@NotNull java.util.Date now, @NotNull String productCode, @NotNull java.util.Date productBuildDate) {
        java.util.Date backdate;
        if (now == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "now", "com/intellij/ide/license/impl/CertKey", "isApplicableTo"));
        }
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "isApplicableTo"));
        }
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/impl/CertKey", "isApplicableTo"));
        }
        ProductData pd = this.findProductData(productCode);
        if (pd == null) {
            return false;
        }
        java.util.Date subEnd = pd.getPaidUpTo();
        if (subEnd == null) {
            return true;
        }
        if (now.before(subEnd = CertKey.plusDays(subEnd, 1))) {
            return true;
        }
        int grace = this.getGracePeriodDays();
        if (grace > 0 && (backdate = CertKey.plusDays(now, -grace)).before(subEnd)) {
            return true;
        }
        return CertKey.isPerpetual(pd, productBuildDate);
    }

    private static boolean isPerpetual(ProductData pd, @NotNull java.util.Date productBuildDate) {
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/impl/CertKey", "isPerpetual"));
        }
        java.util.Date fallback = pd.getFallbackDate();
        return fallback != null && productBuildDate.before(CertKey.plusDays(fallback, 1));
    }

    @Nullable
    public String getApplicableWarningMessage(@NotNull java.util.Date now, @NotNull String productCode, @NotNull java.util.Date productBuildDate) {
        java.util.Date backdate;
        if (now == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "now", "com/intellij/ide/license/impl/CertKey", "getApplicableWarningMessage"));
        }
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "getApplicableWarningMessage"));
        }
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/impl/CertKey", "getApplicableWarningMessage"));
        }
        ProductData pd = this.findProductData(productCode);
        if (pd == null) {
            return null;
        }
        if (CertKey.isPerpetual(pd, productBuildDate)) {
            return null;
        }
        java.util.Date subEnd = pd.getPaidUpTo();
        if (subEnd == null) {
            return null;
        }
        java.util.Date subEndExclusive = CertKey.plusDays(subEnd, 1);
        if (now.before(subEndExclusive)) {
            if (this.isAutoProlongated()) {
                return null;
            }
            java.util.Date weekBackdate = CertKey.plusDays(subEnd, -7);
            if (now.before(weekBackdate)) {
                return null;
            }
            ApplicationInfoEx app = ApplicationInfoImpl.getShadowInstance();
            return "Your " + app.getVersionName() + " subscription expires on " + DateFormatUtil.formatDate((java.util.Date)subEnd) + ".\nAfter this date you will no longer able to use " + app.getFullApplicationName();
        }
        int grace = this.getGracePeriodDays();
        if (grace > 0 && (backdate = CertKey.plusDays(now, -grace)).before(subEndExclusive)) {
            java.util.Date graceEnd = CertKey.plusDays(subEnd, grace);
            if (this.isAutoProlongated()) {
                int prolongationGrace = Math.max(0, Math.min(3, grace - 3));
                java.util.Date autoProlongationGraceEnd = CertKey.plusDays(subEndExclusive, prolongationGrace);
                if (!now.before(autoProlongationGraceEnd)) {
                    return "Something went wrong with license auto-prolongation.\nPlease make sure the contract is prolonged until " + DateFormatUtil.formatDate((java.util.Date)graceEnd) + ",\notherwise usage of " + ApplicationInfoImpl.getShadowInstance().getVersionName() + " will no longer be possible.";
                }
            } else {
                ApplicationInfoEx app = ApplicationInfoImpl.getShadowInstance();
                return "Your " + app.getVersionName() + " subscription expired on " + DateFormatUtil.formatDate((java.util.Date)subEnd) + ".\nIf you don't renew it before " + DateFormatUtil.formatDate((java.util.Date)graceEnd) + ", you will no longer be able to use " + app.getFullApplicationName();
            }
        }
        return null;
    }

    @NotNull
    private static java.util.Date plusDays(@NotNull java.util.Date date, int dayCount) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/ide/license/impl/CertKey", "plusDays"));
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, dayCount);
        java.util.Date date2 = calendar.getTime();
        if (date2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/CertKey", "plusDays"));
        }
        return date2;
    }

    @Nullable
    private ProductData findProductData(@NotNull String productCode) {
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKey", "findProductData"));
        }
        List products = ((Supplier<List>)() -> ((LicenseData)Ref.deref(this.myKeyData)).getProducts()).get();
        if (products == null || products.isEmpty()) {
            return null;
        }
        for (ProductData pd : products) {
            if (!productCode.equals(pd.getCode())) continue;
            return pd;
        }
        return null;
    }

    private static final class JetProfileDateAdapter
    implements JsonSerializer<java.util.Date>,
    JsonDeserializer<java.util.Date> {
        private JetProfileDateAdapter() {
        }

        private static DateFormat getFormat() {
            return new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        }

        public JsonElement serialize(java.util.Date src, Type typeOfSrc, JsonSerializationContext context2) {
            String dateFormatAsString = JetProfileDateAdapter.getFormat().format(src);
            return new JsonPrimitive(dateFormatAsString);
        }

        public java.util.Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context2) throws JsonParseException {
            java.util.Date result2;
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("The date should be a string value");
            }
            try {
                result2 = JetProfileDateAdapter.getFormat().parse(json.getAsString());
            }
            catch (ParseException e2) {
                throw new JsonSyntaxException(json.getAsString(), (Throwable)e2);
            }
            if (typeOfT == java.util.Date.class) {
                return result2;
            }
            if (typeOfT == Timestamp.class) {
                return new Timestamp(result2.getTime());
            }
            if (typeOfT == Date.class) {
                return new Date(result2.getTime());
            }
            throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + typeOfT);
        }
    }
}

