/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.licensecommon.license.AbstractLicenseData;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class CertKeyLicenseData
extends AbstractLicenseData
implements CertKeyLicense {
    @NotNull
    private final String myKey;
    @NotNull
    private final String myProductCode;
    @NotNull
    private final Date myProductBuildDate;
    private final CertKey myCertKey;

    public CertKeyLicenseData(@NotNull String key, @NotNull String productCode, @NotNull Date productBuildDate) throws LicenseCreationException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/license/impl/CertKeyLicenseData", "<init>"));
        }
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/CertKeyLicenseData", "<init>"));
        }
        if (productBuildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productBuildDate", "com/intellij/ide/license/impl/CertKeyLicenseData", "<init>"));
        }
        super(true, false);
        this.myKey = key;
        this.myProductCode = productCode;
        this.myProductBuildDate = productBuildDate;
        this.myCertKey = new CertKey(key);
    }

    @Override
    @NotNull
    public String getKey() {
        String string2 = this.myKey;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/CertKeyLicenseData", "getKey"));
        }
        return string2;
    }

    @Override
    @NotNull
    public CertKey getCertKey() {
        CertKey certKey = this.myCertKey;
        if (certKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/CertKeyLicenseData", "getCertKey"));
        }
        return certKey;
    }

    @Override
    @NotNull
    public String getProductCode() {
        String string2 = this.myProductCode;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/CertKeyLicenseData", "getProductCode"));
        }
        return string2;
    }

    @Override
    @NotNull
    public Date getProductBuildDate() {
        Date date = this.myProductBuildDate;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/CertKeyLicenseData", "getProductBuildDate"));
        }
        return date;
    }

    @Override
    public boolean isExpired(Date currentDate) {
        return !this.myCertKey.isApplicableTo(currentDate, this.getProductCode(), this.getProductBuildDate());
    }

    @Override
    public Date getExpirationDate() {
        return this.myCertKey.getExpirationDate(this.getProductCode());
    }

    @Override
    public String getUserName() {
        return this.getLicensedTo();
    }

    @Override
    public boolean isNonCommercial() {
        return false;
    }

    @Override
    public boolean shouldDetectDuplicates() {
        return this.myCertKey.isCheckConcurrentUse();
    }

    @Override
    public boolean isPersonal() {
        return false;
    }

    @Override
    public boolean isYearAcademic() {
        return false;
    }

    @Override
    public boolean isOpenSource() {
        return false;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public Date getGenerationDate() {
        return new Date();
    }
}

