/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.impl.LicenseServerSource;
import com.jetbrains.ls.util.DnsUtil;
import org.jetbrains.annotations.Nullable;

public class DefaultLicenseServerUtil {
    @Nullable
    public static String discoverAndPing() {
        try {
            String defaultUrl = DefaultLicenseServerUtil.discoverServerUrl();
            if (DefaultLicenseServerUtil.ping(defaultUrl)) {
                return defaultUrl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean ping(String serverUrl) {
        LicenseSource[] licenseSources;
        if (serverUrl == null) {
            return false;
        }
        LicenseManager licenseManager = LicenseManager.getInstance();
        if (licenseManager instanceof GeneralLicenseManager && (licenseSources = ((GeneralLicenseManager)licenseManager).getLicenseSources()) != null) {
            for (LicenseSource source : licenseSources) {
                if (!(source instanceof LicenseServerSource)) continue;
                if (!((LicenseServerSource)source).ping(serverUrl)) break;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String discoverServerUrl() {
        return DnsUtil.detectServerUrl();
    }
}

