/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.licensecommon.license.AbstractLicenseData;
import java.util.Date;
import org.jetbrains.annotations.NonNls;

public final class EvaluationLicenseData
extends AbstractLicenseData {
    @NonNls
    public static final String ID = "Evaluation";
    private final long evalPeriodInMs;
    private final Date issueDate;
    private final int myMajorVersion;
    private final String myEvaluatorName;
    private static final long DAY = 86400000L;

    public EvaluationLicenseData(Date issueDate, int majorVersion, String evaluatorName, int evalPeriod) {
        super(true, false);
        this.issueDate = issueDate;
        this.evalPeriodInMs = (long)evalPeriod * 86400000L;
        this.myMajorVersion = majorVersion;
        this.myEvaluatorName = evaluatorName;
    }

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public boolean isExpired(Date currentDate) {
        long between = currentDate.getTime() - this.issueDate.getTime();
        return between < 0L && -between > 86400000L || between > this.evalPeriodInMs;
    }

    @Override
    public Date getExpirationDate() {
        return new Date(this.issueDate.getTime() + this.evalPeriodInMs);
    }

    @Override
    public String getUserName() {
        return this.myEvaluatorName;
    }

    @Override
    public boolean isNonCommercial() {
        return false;
    }

    @Override
    public boolean shouldDetectDuplicates() {
        return false;
    }

    @Override
    public boolean isPersonal() {
        return false;
    }

    @Override
    public boolean isHacked() {
        return false;
    }

    @Override
    public boolean isYearAcademic() {
        return false;
    }

    @Override
    public boolean isOpenSource() {
        return false;
    }

    @Override
    public int getMajorVersion() {
        return this.myMajorVersion;
    }

    @Override
    public Date getGenerationDate() {
        return this.issueDate;
    }
}

