/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.notification.NotificationType;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class ExpirationDateCheck {
    public static final long DEFAULT_CHECK_PERIOD = 86400000L;
    public static final long FREE_RUN_PERIOD = 1800000L;
    private final LicenseManager myLicenseManager;
    private final AtomicBoolean myValidationInProgress = new AtomicBoolean(false);
    private volatile String myLastCheckedLicenseId = null;
    private volatile Date myFreeRunStart = null;
    private final AtomicReference<ScheduledFuture<?>> myPendingTask = new AtomicReference<Object>(null);

    public ExpirationDateCheck(LicenseManager licenseManager) {
        this.myLicenseManager = licenseManager;
    }

    public void scheduleValidation(long delay) {
        ScheduledFuture<?> previous = this.myPendingTask.getAndSet(JobScheduler.getScheduler().schedule(new ValidationTask(), delay, TimeUnit.MILLISECONDS));
        if (previous != null) {
            previous.cancel(false);
        }
    }

    private class ValidationTask
    implements Runnable {
        private ValidationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ExpirationDateCheck.this.myValidationInProgress.getAndSet(true)) {
                return;
            }
            long nextCheckDelay = 86400000L;
            try {
                LicenseData license;
                LicenseSource source = ExpirationDateCheck.this.myLicenseManager.getActualSource();
                LicenseData licenseData = license = source != null ? source.getLicense() : null;
                if (!(license instanceof CertKeyLicense)) {
                    ExpirationDateCheck.this.myLastCheckedLicenseId = null;
                    ExpirationDateCheck.this.myFreeRunStart = null;
                    if (license == null) {
                        nextCheckDelay = 900000L;
                    }
                    return;
                }
                CertKeyLicense certKeyLicense = (CertKeyLicense)((Object)license);
                String productCode = certKeyLicense.getProductCode();
                Date buildDate = certKeyLicense.getProductBuildDate();
                CertKey certKey = certKeyLicense.getCertKey();
                Date freeRunStart = ExpirationDateCheck.this.myFreeRunStart;
                if (certKey.getLicenseId().equals(ExpirationDateCheck.this.myLastCheckedLicenseId) && freeRunStart != null) {
                    Date now = new Date();
                    long elapsed = now.getTime() - freeRunStart.getTime();
                    if (elapsed >= 1800000L) {
                        ExpirationDateCheck.this.myLicenseManager.getLicenseFactory().getLicenseMessages().showLicenseExpiredBeforeShutdownNotification(false);
                        GeneralLicenseManager.shutdownApplication();
                    } else {
                        nextCheckDelay = 1800000L - elapsed;
                    }
                } else {
                    ExpirationDateCheck.this.myFreeRunStart = null;
                    ExpirationDateCheck.this.myLastCheckedLicenseId = certKey.getLicenseId();
                    Date now = new Date();
                    if (certKey.isApplicableTo(now, productCode, buildDate)) {
                        long timeLeftBeforeExpiration;
                        Date expiration;
                        String message2 = certKey.getApplicableWarningMessage(now, productCode, buildDate);
                        if (message2 != null) {
                            LicenseEntryUtil.showLicenseNotificationLater("Subscription Validation", message2, NotificationType.WARNING);
                        }
                        if ((expiration = certKey.getFirstExpiredDate(productCode)) != null && (timeLeftBeforeExpiration = expiration.getTime() - now.getTime()) > 0L) {
                            nextCheckDelay = Math.min(86400000L, timeLeftBeforeExpiration + 15000L);
                        }
                    } else {
                        boolean register2 = ExpirationDateCheck.this.myLicenseManager.getLicenseFactory().getLicenseMessages().askEnterKeyBecauseLicenseExpired(false);
                        if (register2) {
                            ExpirationDateCheck.this.myLicenseManager.register();
                        } else {
                            ExpirationDateCheck.this.myFreeRunStart = new Date();
                            nextCheckDelay = 1815000L;
                        }
                    }
                }
            }
            finally {
                ExpirationDateCheck.this.scheduleValidation(nextCheckDelay);
                ExpirationDateCheck.this.myValidationInProgress.set(false);
            }
        }
    }
}

