/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseTarget;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.CertKeyLicenseData;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.ide.license.impl.LicenseKeySource;
import com.intellij.ide.license.impl.TargetSaveException;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.ls.responses.Action;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.ls.responses.ValidateKeyResponse;
import com.jetbrains.ls.util.JBAClientUtil;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class FileLicenseSource
extends LicenseKeySource
implements LicenseTarget {
    private final LicenseFile myLicenseFile;
    @NotNull
    private final GeneralLicenseManager myLicenseManager;
    private final AtomicBoolean myServerValidationInProgress;
    private volatile ScheduledFuture<?> myNextScheduledServerValidation;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    @Override
    public void create() throws LicenseCreationException {
        throw new UnsupportedOperationException();
    }

    public void create(LicenseData licenseData) {
        this.setLicense(licenseData);
    }

    @Override
    public void restore() {
        this.setLicense(this.myLicenseFile.getLicense());
    }

    @Override
    public boolean hasCachedData() {
        return this.getLicense() != null || this.myLicenseFile.getLicense() != null;
    }

    @Override
    public void clear() {
        this.myLicenseFile.delete();
        this.setLicense(null);
    }

    public FileLicenseSource(@NotNull GeneralLicenseManager manager, LicenseFactory factory2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/license/impl/FileLicenseSource", "<init>"));
        }
        super(factory2);
        this.myServerValidationInProgress = new AtomicBoolean(false);
        this.myLicenseManager = manager;
        this.myLicenseFile = factory2.getLicenseFile();
    }

    @Override
    public void save(LicenseData license) throws TargetSaveException {
        this.myLicenseFile.save(license);
    }

    public LicenseFactory getFactory() {
        return this.factory;
    }

    @Override
    public void validate() throws ValidationFailedException {
        super.validate();
        this.scheduleServerValidation();
    }

    private void scheduleServerValidation() {
        PooledThreadExecutor.INSTANCE.submit(() -> {
            if (this.myServerValidationInProgress.getAndSet(true)) {
                return;
            }
            long nextValidation = 86400000L;
            try {
                String key;
                CertKeyLicense currentCertKeyLicense;
                LicenseData licenseData = this.getLicense();
                CertKeyLicense certKeyLicense = currentCertKeyLicense = licenseData instanceof CertKeyLicense ? (CertKeyLicense)((Object)licenseData) : null;
                String string2 = currentCertKeyLicense != null ? currentCertKeyLicense.getCertKey().getLicenseId() : (key = licenseData != null ? licenseData.getKey() : null);
                if (key == null || StringUtil.isEmptyOrSpaces((String)key)) {
                    nextValidation = 3600000L;
                } else {
                    try {
                        String licenseHash = currentCertKeyLicense != null ? currentCertKeyLicense.getCertKey().getHash() : null;
                        ValidateKeyResponse response = JBAClientUtil.validateLicenseKey(this.factory.getProductDescriptor().getProductCode(), key, licenseHash != null ? licenseHash : "");
                        if (response.getResponseCode() != ResponseCode.SERVER_INTERNAL_ERROR) {
                            long period = response.getValidationPeriod();
                            if (period > 0L) {
                                nextValidation = period;
                            }
                            if (response.getResponseCode() == ResponseCode.OK) {
                                String newKey = response.getNewLicenseKey();
                                if (newKey != null && !newKey.isEmpty() && currentCertKeyLicense != null) {
                                    CertKeyLicenseData updatedLicenseData = new CertKeyLicenseData(newKey, currentCertKeyLicense.getProductCode(), currentCertKeyLicense.getProductBuildDate());
                                    this.save(updatedLicenseData);
                                    this.setLicense(updatedLicenseData);
                                    this.myLicenseManager.scheduleLicenseExpirationCheckNow();
                                    this.checkSameAssignee(currentCertKeyLicense.getCertKey().getAssigneeName(), updatedLicenseData.getCertKey().getAssigneeName());
                                }
                            } else {
                                String message2;
                                Action action2 = response.getAction();
                                if (action2 == null) {
                                    action2 = Action.NONE;
                                }
                                if (action2 == Action.REVOKE) {
                                    this.clear();
                                    LicenseEntryUtil.invokeOnEdtWhenApplicationLoaded(() -> this.myLicenseManager.askUserForLicense(new LicenseManager.StartupAction(){

                                        @Override
                                        public void cancel() {
                                            GeneralLicenseManager.shutdownApplication();
                                        }

                                        @Override
                                        public boolean cancelMeansShutdown() {
                                            return true;
                                        }
                                    }, this, response.getMessage()));
                                } else if (action2 == Action.WARN && (message2 = response.getMessage()) != null && !message2.trim().isEmpty()) {
                                    LicenseEntryUtil.showLicenseNotificationLater("License Validation", message2, NotificationType.WARNING);
                                }
                            }
                        }
                    }
                    catch (Throwable licenseHash) {
                        // empty catch block
                    }
                }
                ScheduledFuture<?> previousValidation = this.myNextScheduledServerValidation;
                if (previousValidation != null && !previousValidation.isDone()) {
                    previousValidation.cancel(false);
                }
            }
            finally {
                this.myNextScheduledServerValidation = JobScheduler.getScheduler().schedule(() -> this.scheduleServerValidation(), nextValidation, TimeUnit.MILLISECONDS);
                this.myServerValidationInProgress.set(false);
            }
        });
    }

    private void checkSameAssignee(String wasAssignedTo, String nowAssignedTo) {
        if (wasAssignedTo == null || wasAssignedTo.isEmpty() || nowAssignedTo == null || nowAssignedTo.isEmpty() || wasAssignedTo.equals(nowAssignedTo)) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.myLicenseManager.askUserForLicense(new LicenseManager.StartupAction(), this, "The license you have been using has been reassigned to '" + nowAssignedTo + "'.<br>If you are not this person you need to use another license data."));
    }
}

