/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.license.GeneralLicenseEntry;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.LicenseTarget;
import com.intellij.ide.license.common.EAPUsageCollector;
import com.intellij.ide.license.impl.BuiltInEvaluationSource;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.EvaluationExpiredException;
import com.intellij.ide.license.impl.EvaluationLicenseData;
import com.intellij.ide.license.impl.ExpirationDateCheck;
import com.intellij.ide.license.impl.FileLicenseSource;
import com.intellij.ide.license.impl.GeneralLicenseSource;
import com.intellij.ide.license.impl.IdeaLoggerFactory;
import com.intellij.ide.license.impl.InvalidLicenseException;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.ide.license.impl.LicenseCorruptedException;
import com.intellij.ide.license.impl.LicenseExpiredException;
import com.intellij.ide.license.impl.LicenseNeedUpgradeException;
import com.intellij.ide.license.impl.LicenseServerSource;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.ide.license.impl.ServerSource;
import com.intellij.ide.license.impl.TargetSaveException;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.licensecommon.client.LicenseClientApplication;
import com.intellij.licensecommon.client.impl.ClientImpl;
import com.intellij.licensecommon.license.LicenseBroadcastData;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.MaintenanceDueAware;
import com.intellij.licensecommon.log.Log;
import com.intellij.licensecommon.message.MessageFactory;
import com.intellij.licensecommon.message.impl.ResharperMessage;
import com.intellij.licensecommon.net.Address;
import com.intellij.licensecommon.net.impl.NetworkImpl;
import com.intellij.licensecommon.net.impl.NetworkSocketFactoryImpl;
import com.intellij.licensecommon.protocol.impl.ResharperProtocol;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.jetbrains.ls.util.RSAEncoder;
import java.awt.GraphicsEnvironment;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public abstract class GeneralLicenseManager
extends LicenseManager
implements LicenseClientApplication {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.license.impl.GeneralLicenseManager");
    private volatile LicenseSource myActualSource;
    protected final ClientImpl myClient;
    private LicenseFactory licenseFactory;
    protected LicenseSource[] licenseSources;
    private final AtomicBoolean myIsLicenseCollisionDialogShown = new AtomicBoolean(false);
    private final ExpirationDateCheck myExpirationDateCheck;
    private BigInteger VERIFY_PRIVATE_MOD;
    private BigInteger VERIFY_PRIVATE_EXP;

    public GeneralLicenseManager() {
        Log.FACTORY = new IdeaLoggerFactory();
        this.myClient = new ClientImpl<ResharperMessage>(this, new NetworkImpl<ResharperMessage>(new NetworkSocketFactoryImpl(), new ResharperProtocol(), PooledThreadExecutor.INSTANCE), new MessageFactory<ResharperMessage>(){

            @Override
            public ResharperMessage createBroadcastMessage(LicenseBroadcastData data) {
                return new ResharperMessage(data);
            }
        }, JobScheduler.getScheduler());
        this.myExpirationDateCheck = new ExpirationDateCheck(this);
    }

    public void scheduleLicenseExpirationCheckNow() {
        this.myExpirationDateCheck.scheduleValidation(60000L);
    }

    @Override
    public LicenseSource getActualSource() {
        return this.myActualSource;
    }

    @Nullable
    protected LicenseData getLicenseData() {
        LicenseSource source = this.myActualSource;
        return source != null ? source.getLicense() : null;
    }

    @Override
    public void startUp(final LicenseManager.StartupAction action2) {
        this.getLicenseFactory();
        this.createLicenseSources(this.licenseFactory);
        LicenseManager.StartupAction wrappedAction = new LicenseManager.StartupAction(){

            @Override
            public void proceed() {
                GeneralLicenseManager.this.VERIFY_PRIVATE_MOD = new BigInteger("ba3da866372947f737c0120610ae281f1085659726cbd2b1288ac7a2b95acef7392d4c848d4cab7767c2c972bdf4e4f73482ef23fb31bf6dda4cbcbf82924d97", 16);
                GeneralLicenseManager.this.VERIFY_PRIVATE_EXP = new BigInteger("395af9bc98ea4eae74ede2df194df92f2ff0550c0ab7a4a8487b0ce6313d25157905b0b480f3e13b86a06e69b120ee687bbca0b93f6c512241261862a5d76f89", 16);
                Extensions.getRootArea().addAvailabilityListener(UsagesCollector.EP_NAME.getName(), new ExtensionPointAvailabilityListener(){
                    private final AtomicBoolean registered = new AtomicBoolean(false);

                    public void extensionPointRegistered(ExtensionPoint extensionPoint) {
                        if (!this.registered.getAndSet(true)) {
                            extensionPoint.registerExtension((Object)new EAPUsageCollector());
                        }
                    }

                    public void extensionPointRemoved(ExtensionPoint extensionPoint) {
                    }
                });
                action2.proceed();
            }

            @Override
            public void cancel() {
                action2.cancel();
            }

            @Override
            public boolean cancelMeansShutdown() {
                return action2.cancelMeansShutdown();
            }
        };
        this.proceedWithLicenseOrExit(wrappedAction);
    }

    private void proceedWithLicenseOrExit(LicenseManager.StartupAction action2) {
        boolean headless = GraphicsEnvironment.isHeadless();
        for (LicenseSource source : this.getSortedLicenseSources()) {
            boolean needPanel;
            Status status;
            LicenseData licenseFromSource;
            if (source.getLicense() == null) {
                source.restore();
            }
            if ((licenseFromSource = source.getLicense()) == null || (status = this.validateLicense(action2, source)) == Status.SKIP) continue;
            UpdateChecker.addUpdateRequestParameter("license", GeneralLicenseManager.licenseInfo(licenseFromSource));
            if (status != Status.OK) break;
            boolean bl = needPanel = !headless && this.showExpirationWarning(licenseFromSource, licenseFromSource instanceof EvaluationLicenseData);
            if (needPanel) break;
            this.saveAndProceed(action2, source, licenseFromSource);
            return;
        }
        if (headless) {
            LOG.error("No valid license found");
            System.exit(-1);
        } else {
            this.myExpirationDateCheck.scheduleValidation(900000L);
            this.askUser(action2);
        }
    }

    private static String licenseInfo(LicenseData licenseData) {
        if (licenseData instanceof EvaluationLicenseData) {
            return "eval";
        }
        StringBuilder licenseInfo = new StringBuilder();
        if (licenseData instanceof ServerLicenseData) {
            licenseInfo.append("server,");
        }
        if (licenseData.isYearAcademic()) {
            licenseInfo.append("classroom");
        } else if (licenseData.isPersonal()) {
            licenseInfo.append("personal");
        } else if (licenseData.isOpenSource()) {
            licenseInfo.append("opensource");
        } else if (licenseData.isNonCommercial()) {
            licenseInfo.append("academic");
        } else {
            licenseInfo.append("commercial");
        }
        return licenseInfo.toString();
    }

    private LicenseSource[] getSortedLicenseSources() {
        LicenseSource[] sources = this.getLicenseSources();
        LicenseSource knownGoodSource = null;
        for (LicenseSource source : sources) {
            try {
                source.restore();
                if (source.getLicense() == null) continue;
                source.validate();
            }
            catch (Exception e2) {
                continue;
            }
            knownGoodSource = source;
            break;
        }
        if (knownGoodSource != null) {
            ArrayList<LicenseSource> sorted = new ArrayList<LicenseSource>(Arrays.asList(sources));
            sorted.remove(knownGoodSource);
            sorted.add(0, knownGoodSource);
            return sorted.toArray(new LicenseSource[sorted.size()]);
        }
        return sources;
    }

    @Override
    public void releasePermanentLicense() {
        LicenseData licenseData;
        LicenseSource source = this.getActualSource();
        if (source instanceof LicenseServerSource && (licenseData = this.getLicenseData()) instanceof ServerLicenseData) {
            ((LicenseServerSource)source).releasePermanentLicense();
            ((ServerLicenseData)licenseData).setPermanent(false);
        }
    }

    @Override
    public void obtainPermanentLicenseFromServer() {
        ServerLicenseData data;
        LicenseSource source = this.getActualSource();
        if (source instanceof LicenseServerSource && (data = ((LicenseServerSource)source).obtainPermanentLicenseFromServer()) != null) {
            this.saveAndProceed(new LicenseManager.StartupAction(), source, data);
        }
    }

    protected void askUser(LicenseManager.StartupAction action2) {
        this.askUserForLicense(action2, this.getActualSource(), null);
    }

    public LicenseSource[] getLicenseSources() {
        return this.licenseSources;
    }

    protected boolean showExpirationWarning(@Nullable LicenseData licenseData, boolean evaluation) {
        if (licenseData == null || licenseData instanceof CertKeyLicense) {
            return false;
        }
        Date expirationDate = licenseData.getExpirationDate();
        if (expirationDate == null) {
            return false;
        }
        long timeBeforeExpiration = expirationDate.getTime() - System.currentTimeMillis();
        if (timeBeforeExpiration >= 0L && timeBeforeExpiration <= GeneralLicenseManager.days(7)) {
            long daysBeforeExpiration = timeBeforeExpiration / GeneralLicenseManager.days(1);
            return this.getLicenseFactory().getLicenseMessages().showWillExpireWarning(daysBeforeExpiration, evaluation);
        }
        return false;
    }

    private static long days(int days) {
        return (long)days * 24L * 60L * 60L * 1000L;
    }

    @NotNull
    protected Status validateLicense(LicenseManager.StartupAction action2, LicenseSource source) {
        boolean isInteractiveMode = !GraphicsEnvironment.isHeadless();
        try {
            source.validate();
        }
        catch (LicenseCorruptedException e2) {
            if (isInteractiveMode) {
                this.getMessages().showLicenseCorruptMessage();
            } else {
                LOG.info(IdeBundle.message((String)"message.license.is.corrupt", (Object[])new Object[0]));
            }
            Status status = Status.ASK;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        catch (EvaluationExpiredException e3) {
            if (isInteractiveMode) {
                boolean enterLicense = this.getMessages().askEnterKeyBecauseLicenseExpired(true);
                Status status = enterLicense ? Status.ASK : Status.OK;
                if (status == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
                }
                return status;
            }
            LOG.info("Evaluation license expired");
            Status status = Status.ASK;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        catch (InvalidLicenseException e4) {
            if (isInteractiveMode) {
                this.getMessages().showLicenseInvalidMessage();
            } else {
                LOG.info(IdeBundle.message((String)"message.invalid.license.data", (Object[])new Object[0]));
            }
            Status status = Status.ASK;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        catch (LicenseExpiredException e5) {
            if (isInteractiveMode) {
                this.getMessages().showLicenseExpired();
            } else {
                LOG.info(IdeBundle.message((String)"message.license.expired", (Object[])new Object[0]));
            }
            Status status = Status.ASK;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        catch (LicenseNeedUpgradeException e6) {
            if (isInteractiveMode) {
                this.getMessages().showNeedUpgradeMessage(this.createLicenseEntry(action2, this.getActualSource(), null));
            } else {
                LOG.info("The license is not valid for use with this version of the application");
            }
            Status status = Status.ASK;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        catch (ValidationFailedException e7) {
            Status status = Status.SKIP;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        LicenseData effectiveLicense = source.getLicense();
        if (effectiveLicense == null) {
            Status status = Status.SKIP;
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
            }
            return status;
        }
        if (!effectiveLicense.isAccepted()) {
            boolean storedOk;
            boolean isHeadless;
            boolean bl = isHeadless = !isInteractiveMode;
            if (isHeadless || !this.getMessages().doesUserAcceptLicense(effectiveLicense)) {
                if (isHeadless) {
                    LOG.info("A valid license found, but the license agreement is not read and accepted. Must be accepted in interactive mode.");
                }
                action2.cancel();
                Status status = Status.SKIP;
                if (status == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
                }
                return status;
            }
            effectiveLicense.setAccepted(true);
            if (effectiveLicense instanceof EvaluationLicenseData && !(storedOk = this.licenseFactory.storeEvaluationLicense((EvaluationLicenseData)effectiveLicense))) {
                Status status = Status.SKIP;
                if (status == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
                }
                return status;
            }
        }
        Status status = Status.OK;
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "validateLicense"));
        }
        return status;
    }

    private void saveAndProceed(LicenseManager.StartupAction action2, LicenseSource source, LicenseData effectiveLicense) {
        LicenseSource previous = this.myActualSource;
        this.myActualSource = source;
        System.setProperty("idea.registered", String.valueOf(!this.isEvaluationLicense()));
        if (source instanceof LicenseTarget) {
            try {
                ((LicenseTarget)((Object)source)).save(effectiveLicense);
            }
            catch (TargetSaveException e2) {
                LOG.error("License could not be saved due to following error:" + (e2.getMessage() != null ? e2.getMessage() : "NPE"), (Throwable)e2);
                this.getMessages().showSaveLicenseWarning(e2);
            }
        }
        if (previous != source) {
            if (previous instanceof ServerSource) {
                ((ServerSource)previous).releaseLicense();
            } else if (previous instanceof JetprofileSource) {
                ((JetprofileSource)previous).setLicense(null);
            } else if (previous instanceof FileLicenseSource) {
                ((FileLicenseSource)previous).setLicense(null);
            }
        }
        this.proceed(action2);
    }

    private void proceed(LicenseManager.StartupAction action2) {
        SwingUtilities.invokeLater(() -> {
            try {
                action2.proceed();
            }
            finally {
                this.myExpirationDateCheck.scheduleValidation(1200000L);
                LicenseSource source = this.getActualSource();
                if (source != null) {
                    SwingUtilities.invokeLater(() -> {
                        if (source.needNetworkLicenseCheck()) {
                            this.myClient.broadcastLicenseData(GeneralLicenseManager.convertToBroadcastLicense(source.getLicense()));
                            ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                                public void applicationExiting() {
                                    GeneralLicenseManager.this.myClient.broadcastLicenseData(null);
                                }
                            });
                        } else {
                            this.myClient.broadcastLicenseData(null);
                            if (source instanceof ServerSource) {
                                ((ServerSource)source).startPinger();
                            }
                        }
                    });
                }
            }
        });
    }

    private static LicenseBroadcastData convertToBroadcastLicense(LicenseData license) {
        CertKey certKey;
        if (license instanceof CertKeyLicense && (certKey = ((CertKeyLicense)((Object)license)).getCertKey()).isCheckConcurrentUse()) {
            return new LicenseBroadcastData(0, certKey.getLicenseId(), certKey.getLicenseeName(), System.getProperty("user.name", ""));
        }
        return null;
    }

    protected void askUserForLicense(LicenseManager.StartupAction action2, LicenseSource selectedSource, @Nullable String initialStatusMessage) {
        LicenseMessages licenseMessages = this.getMessages();
        licenseMessages.showLicenseEntryScreen(this.createLicenseEntry(action2, selectedSource, initialStatusMessage));
    }

    private GeneralLicenseEntry createLicenseEntry(final LicenseManager.StartupAction action2, LicenseSource selectedSource, @Nullable String statusMessage) {
        return new GeneralLicenseEntry(this.getLicenseSources(), selectedSource, this.getLicenseFactory(), statusMessage){

            @Override
            public void proceed(@NotNull LicenseSource selected) {
                if (selected == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/ide/license/impl/GeneralLicenseManager$4", "proceed"));
                }
                LicenseData selectedData = selected.getLicense();
                Status status = GeneralLicenseManager.this.validateLicense(action2, selected);
                if (status == Status.OK) {
                    UpdateChecker.addUpdateRequestParameter("license", GeneralLicenseManager.licenseInfo(selectedData));
                    GeneralLicenseManager.this.saveAndProceed(action2, selected, selectedData);
                    super.proceed(selected);
                    if (selectedData != null && !(selected instanceof BuiltInEvaluationSource)) {
                        LicenseEntryUtil.showLicenseProceedNotificationLater(selectedData);
                    }
                } else {
                    GeneralLicenseManager.this.askUserForLicense(action2, selected, this.getInitialProblemDescription());
                }
            }

            @Override
            public void forgetLicense() {
                try {
                    super.forgetLicense();
                }
                finally {
                    SwingUtilities.invokeLater(() -> GeneralLicenseManager.this.proceedWithLicenseOrExit(new LicenseManager.StartupAction(){

                        @Override
                        public void cancel() {
                            GeneralLicenseManager.shutdownApplication();
                        }

                        @Override
                        public boolean cancelMeansShutdown() {
                            return true;
                        }
                    }));
                }
            }

            @Override
            public void cancel() {
                action2.cancel();
            }

            @Override
            public boolean cancelMeansShutdown() {
                return action2.cancelMeansShutdown();
            }
        };
    }

    protected abstract LicenseMessages getMessages();

    @Override
    public boolean supportsRegistration() {
        return true;
    }

    @Override
    public void register() {
        this.getMessages().setShowLicenseEntryAsDialog(true);
        this.askUserForLicense(new LicenseManager.StartupAction(), this.getActualSource(), null);
    }

    @Override
    public String licensedToMessage() {
        LicenseData licenseData = this.getLicenseData();
        String licensedToName = licenseData != null ? licenseData.getUserName() : null;
        return licensedToName != null ? IdeBundle.message((String)"message.licensed.to", (Object[])new Object[]{licensedToName}) : "";
    }

    @Override
    @NotNull
    public List<String> licensedRestrictionsMessages() {
        LicenseData licenseData = this.getLicenseData();
        List<String> list2 = licenseData == null ? Collections.emptyList() : this.getMessages().getUsageRestrictionsMessages(licenseData);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "licensedRestrictionsMessages"));
        }
        return list2;
    }

    @Override
    public LicenseFactory getLicenseFactory() {
        if (this.licenseFactory == null) {
            this.licenseFactory = this.createLicenseFactory();
        }
        return this.licenseFactory;
    }

    public void createLicenseSources(LicenseFactory licenseFactory) {
        ArrayList<GeneralLicenseSource> sources = new ArrayList<GeneralLicenseSource>();
        sources.add(new FileLicenseSource(this, licenseFactory));
        sources.add(this.createLicenseServerSource());
        sources.add(this.createJetProfileSource());
        sources.add(this.createBuiltInEvaluationSource(licenseFactory));
        this.licenseSources = sources.toArray(new LicenseSource[sources.size()]);
    }

    private BuiltInEvaluationSource createBuiltInEvaluationSource(LicenseFactory licenseFactory) {
        return new BuiltInEvaluationSource(licenseFactory, this.getEvaluationPeriod());
    }

    public int getEvaluationPeriod() {
        return 30;
    }

    protected LicenseServerSource createLicenseServerSource() {
        return new LicenseServerSource(this.getLicenseFactory(), this);
    }

    @NotNull
    protected JetprofileSource createJetProfileSource() {
        JetprofileSource jetprofileSource = new JetprofileSource(this.getLicenseFactory(), this, null);
        if (jetprofileSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/GeneralLicenseManager", "createJetProfileSource"));
        }
        return jetprofileSource;
    }

    @Override
    public boolean willLicenseExpire() {
        LicenseData licenseData = this.getLicenseData();
        return licenseData != null && licenseData.getExpirationDate() != null;
    }

    @Override
    public boolean isEvaluationLicense() {
        return this.getLicenseData() instanceof EvaluationLicenseData;
    }

    @Override
    public Date getEvaluationExpirationDate() {
        LicenseData licenseData = this.getLicenseData();
        return licenseData instanceof EvaluationLicenseData ? licenseData.getExpirationDate() : null;
    }

    @Override
    public boolean needEvaluationFollowUp() {
        return this.isEvaluationLicense() && !this.isEap();
    }

    @Override
    public boolean isPermanentLicenseServerLicenseSupported() {
        return false;
    }

    @Override
    public boolean hasPermanentLicense() {
        LicenseData licenseData = this.getLicenseData();
        return licenseData instanceof ServerLicenseData && ((ServerLicenseData)licenseData).isPermanent();
    }

    @Override
    @Nullable
    public Date getMaintenanceDueDate() {
        LicenseData licenseData = this.getLicenseData();
        return licenseData instanceof MaintenanceDueAware ? ((MaintenanceDueAware)((Object)licenseData)).getMaintenanceDueDate() : null;
    }

    @Override
    public void duplicateLicenseDetected(Address from, LicenseBroadcastData conflictingData) {
        LicenseData licenseData = this.getLicenseData();
        if (licenseData == null || !licenseData.shouldDetectDuplicates() || from.isAnyLocalAddress()) {
            return;
        }
        if (!this.myIsLicenseCollisionDialogShown.getAndSet(true)) {
            String message2 = GeneralLicenseManager.licenseCollisionText(conflictingData.getUserLogin() + " @ " + from.getDisplay());
            String title = GeneralLicenseManager.licenseCollisionTitle();
            SwingUtilities.invokeLater(() -> {
                try {
                    boolean reActivate;
                    this.myClient.cancelBroadcastTask();
                    boolean bl = reActivate = GeneralLicenseManager.isPreApplication() ? GeneralLicenseManager.preApplicationMessage(message2, title) : GeneralLicenseManager.postApplicationMessage(message2, title);
                    if (reActivate) {
                        this.myClient.broadcastLicenseData(GeneralLicenseManager.convertToBroadcastLicense(this.getLicenseData()));
                    } else {
                        GeneralLicenseManager.shutdownApplication();
                    }
                }
                finally {
                    this.myIsLicenseCollisionDialogShown.set(false);
                }
            });
        }
    }

    private static boolean preApplicationMessage(String message2, String title) {
        int chosen = JOptionPane.showOptionDialog(JOptionPane.getRootFrame(), message2, title, 0, 0, null, new String[]{"Reactivate", "Shutdown"}, "Reactivate");
        return chosen == 0;
    }

    private static boolean postApplicationMessage(String message2, String title) {
        int chosen = Messages.showYesNoDialog((String)message2, (String)title, (String)"Reactivate", (String)"Shutdown", (Icon)Messages.getErrorIcon());
        return chosen == 0;
    }

    private static String licenseCollisionTitle() {
        return IdeBundle.message((String)"title.license.collision.detected", (Object[])new Object[0]);
    }

    private static String licenseCollisionText(String fromText) {
        return IdeBundle.message((String)"error.license.collision", (Object[])new Object[]{fromText});
    }

    static void shutdownApplication() {
        if (GeneralLicenseManager.isPreApplication()) {
            GeneralLicenseManager.preApplicationShutdown();
        } else {
            GeneralLicenseManager.postApplicationShutdown();
        }
    }

    private static boolean isPreApplication() {
        return ApplicationManagerEx.getApplicationEx() == null;
    }

    private static void preApplicationShutdown() {
        System.exit(-1);
    }

    private static void postApplicationShutdown() {
        ApplicationImpl app = (ApplicationImpl)ApplicationManagerEx.getApplicationEx();
        app.invokeLater(() -> app.exit(true, true, false), ModalityState.NON_MODAL);
    }

    @Override
    public String verifyPlugin(BigInteger key) {
        BigInteger exp = this.VERIFY_PRIVATE_EXP;
        BigInteger mod = this.VERIFY_PRIVATE_MOD;
        if (exp != null && mod != null) {
            return new RSAEncoder(exp, mod).encode(key.toByteArray());
        }
        return super.verifyPlugin(key);
    }

    public static enum Status {
        SKIP,
        ASK,
        OK;

    }
}

