/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.LicenseSource;
import com.intellij.ide.license.impl.LegacyKeyException;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.licensecommon.license.LicenseData;
import org.jetbrains.annotations.NotNull;

public abstract class GeneralLicenseSource
implements LicenseSource {
    @NotNull
    protected LicenseFactory factory;
    private volatile LicenseData myLicense;

    public GeneralLicenseSource(@NotNull LicenseFactory factory2) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/ide/license/impl/GeneralLicenseSource", "<init>"));
        }
        this.factory = factory2;
    }

    @Override
    public void validate() throws ValidationFailedException {
        LicenseData lic = this.getLicense();
        if (lic == null) {
            throw new ValidationFailedException();
        }
        try {
            this.factory.getLicenseValidator().validate(lic);
        }
        catch (LegacyKeyException e2) {
            throw e2;
        }
        catch (ValidationFailedException e3) {
            this.setLicense(null);
            throw e3;
        }
    }

    protected LicenseMessages getMessages() {
        return this.factory.getLicenseMessages();
    }

    @Override
    public LicenseData getLicense() {
        return this.myLicense;
    }

    public void setLicense(LicenseData license) {
        this.myLicense = license;
    }
}

