/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseValidator;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.EvaluationExpiredException;
import com.intellij.ide.license.impl.EvaluationLicenseData;
import com.intellij.ide.license.impl.InvalidLicenseException;
import com.intellij.ide.license.impl.LegacyKeyException;
import com.intellij.ide.license.impl.LicenseCorruptedException;
import com.intellij.ide.license.impl.LicenseExpiredException;
import com.intellij.ide.license.impl.ValidationFailedException;
import com.intellij.licensecommon.license.LegacyKeyBasedLicenseData;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.LicenseDataImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneralLicenseValidator
implements LicenseValidator {
    protected GeneralLicenseValidator() {
    }

    @Override
    public final boolean validate(@Nullable LicenseData licenseData) throws ValidationFailedException {
        CertKeyLicense certKeyLicense;
        if (licenseData == null) {
            return false;
        }
        if (!licenseData.isValid()) {
            if (licenseData.isFromUser()) {
                throw new InvalidLicenseException(null);
            }
            throw new LicenseCorruptedException();
        }
        GeneralLicenseValidator.checkHacked(licenseData);
        if (licenseData instanceof LegacyKeyBasedLicenseData) {
            throw new LegacyKeyException("License key is in legacy format", licenseData);
        }
        if (licenseData instanceof CertKeyLicense && !(certKeyLicense = (CertKeyLicense)((Object)licenseData)).getCertKey().isApplicableTo(certKeyLicense.getProductCode())) {
            throw new InvalidLicenseException("Specified activation code is not applicable to this product");
        }
        if (licenseData.isExpired(new Date())) {
            if (licenseData instanceof EvaluationLicenseData) {
                throw new EvaluationExpiredException();
            }
            throw new LicenseExpiredException(licenseData.getExpirationDate());
        }
        if (this.licenseMightNeedUpgrade(licenseData)) {
            this.checkNeedUpgrade(licenseData);
        }
        return true;
    }

    private boolean licenseMightNeedUpgrade(LicenseData licenseData) {
        return !(licenseData instanceof CertKeyLicense) && !licenseData.isOpenSource() && !licenseData.isYearAcademic() && !(licenseData instanceof EvaluationLicenseData);
    }

    protected static void checkHacked(@NotNull LicenseData licenseData) {
        if (licenseData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseData", "com/intellij/ide/license/impl/GeneralLicenseValidator", "checkHacked"));
        }
        LicenseDataImpl.HACKED = licenseData.isHacked();
        if (LicenseDataImpl.HACKED) {
            UpdateChecker.addUpdateRequestParameter("version", ApplicationInfoImpl.getShadowInstance().getMajorVersion());
        }
    }

    protected abstract void checkNeedUpgrade(LicenseData var1) throws ValidationFailedException;
}

