/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.impl.CertKey;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.JBALicenseData;
import com.jetbrains.ls.responses.EncodedAsset;
import com.jetbrains.ls.responses.License;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetProfileCertLicenseData
extends JBALicenseData
implements CertKeyLicense {
    @NotNull
    private final CertKey myCertKey;
    @NotNull
    private final String myProductCode;
    @NotNull
    private final Date myProductBuildDate;

    public JetProfileCertLicenseData(@NotNull String userId, String userLogin, @NotNull String productCode, @NotNull Date buildDate, @NotNull EncodedAsset asset, @NotNull License decodedLicense) throws LicenseCreationException {
        if (userId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userId", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "<init>"));
        }
        if (productCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productCode", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "<init>"));
        }
        if (buildDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDate", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "<init>"));
        }
        if (asset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asset", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "<init>"));
        }
        if (decodedLicense == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decodedLicense", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "<init>"));
        }
        super(userId, userLogin, asset, decodedLicense);
        this.myProductCode = productCode;
        this.myProductBuildDate = buildDate;
        String key = decodedLicense.getLicenseKey();
        if (key == null || key.isEmpty()) {
            throw new LicenseCreationException("Missing license key");
        }
        this.myCertKey = new CertKey(key);
    }

    @Override
    @NotNull
    public String getLicenseId() {
        String string2 = this.myCertKey.getLicenseId();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "getLicenseId"));
        }
        return string2;
    }

    @Override
    @Nullable
    public Date getExpirationDate() {
        return this.myCertKey.getExpirationDate(this.getProductCode());
    }

    @Override
    @NotNull
    public CertKey getCertKey() {
        CertKey certKey = this.myCertKey;
        if (certKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "getCertKey"));
        }
        return certKey;
    }

    @Override
    @NotNull
    public String getProductCode() {
        String string2 = this.myProductCode;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "getProductCode"));
        }
        return string2;
    }

    @Override
    @NotNull
    public Date getProductBuildDate() {
        Date date = this.myProductBuildDate;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetProfileCertLicenseData", "getProductBuildDate"));
        }
        return date;
    }

    @Override
    public int getMajorVersion() {
        return this.getLicense().getProductVersion();
    }

    @Override
    public String getUserName() {
        return this.getLicensedTo();
    }

    @Override
    public boolean isExpired(Date currentDate) {
        return !this.myCertKey.isApplicableTo(currentDate, this.getProductCode(), this.getProductBuildDate());
    }

    @Override
    public boolean shouldDetectDuplicates() {
        return this.myCertKey.isCheckConcurrentUse();
    }

    @Override
    @Nullable
    public String getRestrictionsText() {
        return this.myCertKey.getLicenseRestriction();
    }
}

