/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.Prefs;
import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseManager;
import com.intellij.ide.license.LicenseTarget;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.impl.CertKeyLicense;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.impl.GeneralLicenseSource;
import com.intellij.ide.license.impl.JBALicenseData;
import com.intellij.ide.license.impl.JetProfileCertLicenseData;
import com.intellij.ide.license.impl.JetProfileLicenseData;
import com.intellij.ide.license.impl.JetProfileSubscriptionLicenseData;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.ide.license.impl.LicensingProxyService;
import com.intellij.ide.license.impl.TargetSaveException;
import com.intellij.ide.license.ui.LicenseEntryUtil;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.util.SubscriptionVersion;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.ls.responses.Action;
import com.jetbrains.ls.responses.EncodedAsset;
import com.jetbrains.ls.responses.License;
import com.jetbrains.ls.responses.ObtainLicenseResponse;
import com.jetbrains.ls.responses.ObtainUserIdResponse;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.ls.responses.ValidateLicenseResponse;
import com.jetbrains.ls.util.DecodeException;
import com.jetbrains.ls.util.JBAClientUtil;
import com.jetbrains.ls.util.VerificationFailedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetprofileSource
extends GeneralLicenseSource
implements LicenseTarget {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.license.impl.JetprofileSource");
    private static final long DEFAULT_CHECK_PERIOD = 3600000L;
    private static final long OFFLINE_WARNING_PERIOD = 172800000L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static final byte[] SECRET = "The Drive to Develop.".getBytes(CHARSET);
    private final AtomicReference<JBALicenseData> myLicenseRef;
    private final long myBuildDate;
    private final GeneralLicenseManager myLicenseManager;
    @Nullable
    private final String myEdition;
    private final LicenseFile myLicenseFile;
    private String myLogin;
    private String myPassword;
    private volatile ScheduledFuture<?> myPeriodicCheckFuture;
    private volatile List<JBALicenseData> myAvailableLicenses;
    private volatile boolean myFirstCheckPerformed;
    private volatile long myLastOfflineWarningStamp;
    private static AtomicBoolean myOnlineValidationInProgress = new AtomicBoolean(false);

    public JetprofileSource(@NotNull LicenseFactory factory2, GeneralLicenseManager licenseManager, @Nullable String edition) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/ide/license/impl/JetprofileSource", "<init>"));
        }
        super(factory2);
        this.myLicenseRef = new AtomicReference<Object>(null);
        this.myAvailableLicenses = Collections.emptyList();
        this.myFirstCheckPerformed = false;
        this.myLastOfflineWarningStamp = -1L;
        this.myLicenseManager = licenseManager;
        this.myBuildDate = SubscriptionVersion.createVersion(JetprofileSource.getBuildDate());
        this.myEdition = edition;
        this.myLicenseFile = factory2.getLicenseFile();
    }

    @NotNull
    public String getProductCode() {
        String string2 = this.factory.getProductDescriptor().getProductCode();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetprofileSource", "getProductCode"));
        }
        return string2;
    }

    @Override
    public void save(LicenseData license) throws TargetSaveException {
        this.myLicenseFile.save(license);
    }

    @Override
    public void create() throws LicenseCreationException {
        block8: {
            try {
                String login = this.myLogin;
                JBALicenseData licenseData = this.obtainRemoteLicense(login, this.myPassword);
                this.setLicense(licenseData);
                if (licenseData != null) {
                    this.storeAssetInfo(licenseData, true);
                    this.scheduleRemoteValidation(this.getValidationPeriod());
                    break block8;
                }
                throw new LicenseCreationException("License Not Found", "No suitable licenses associated with account " + login);
            }
            catch (LicenseCreationException e2) {
                this.setLicense(null);
                throw e2;
            }
            catch (Throwable e3) {
                this.setLicense(null);
                this.myLogin = null;
                String reason = e3.getMessage();
                LOG.info("Unexpected JBA connection error: " + (reason != null ? e3.getClass().getName() + ": " + reason : e3.getClass().getName()));
                LicenseCreationException creationException = new LicenseCreationException("JetBrains Account Error", reason);
                if (e3 instanceof IOException) {
                    creationException.initCause(e3);
                }
                throw creationException;
            }
            finally {
                this.myPassword = null;
            }
        }
    }

    private static Date getBuildDate() {
        return ApplicationInfoImpl.getShadowInstance().getMajorReleaseBuildDate().getTime();
    }

    @Nullable
    private JBALicenseData obtainRemoteLicense(String login, String password) throws Exception {
        String userId = JetprofileSource.obtainUserId(login, password);
        ObtainLicenseResponse response = this.obtainLicense(userId);
        String responseMessage = response.getMessage();
        if (response.getResponseCode() != ResponseCode.OK) {
            StringBuilder message2 = new StringBuilder();
            message2.append("Error fetching licenses for ").append(login);
            if (!StringUtil.isEmptyOrSpaces((String)responseMessage)) {
                message2.append(": ").append(responseMessage);
            }
            throw new Exception(message2.toString());
        }
        List<JBALicenseData> allLicenses = this.createLicenses(login, userId, response.getAssets());
        if (allLicenses.isEmpty()) {
            return null;
        }
        JetprofileSource.updateSharedUserId(userId, login);
        this.myAvailableLicenses = allLicenses;
        this.updateValidationStamp(System.currentTimeMillis());
        this.updateValidationPeriod(response.getValidationPeriod(), response.getValidationDeadlinePeriod());
        return allLicenses.get(0);
    }

    @NotNull
    private List<JBALicenseData> createLicenses(String login, String userId, Collection<EncodedAsset> assets) {
        if (assets.isEmpty()) {
            List<JBALicenseData> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetprofileSource", "createLicenses"));
            }
            return list2;
        }
        SmartList allLicenses = new SmartList();
        Date now = new Date();
        for (EncodedAsset asset : assets) {
            try {
                JBALicenseData lic = JetprofileSource.createLicenseData(login, userId, this.factory.getProductDescriptor(), asset);
                if (lic.isExpired(now)) continue;
                allLicenses.add(lic);
            }
            catch (LicenseCreationException e2) {
                StringBuilder message2 = new StringBuilder(e2.getMessage());
                String details = e2.getDetails();
                if (details != null) {
                    message2.append(": ").append(details);
                }
                LOG.info(message2.toString());
            }
            catch (Throwable e3) {
                LOG.info(e3.getMessage());
            }
        }
        SmartList smartList = allLicenses;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetprofileSource", "createLicenses"));
        }
        return smartList;
    }

    private static JBALicenseData createLicenseData(String login, String userId, ProductDescriptor productDescriptor, EncodedAsset asset) throws LicenseCreationException, DecodeException {
        License decoded = asset.decode();
        if (decoded.getLicenseKey() != null) {
            return new JetProfileCertLicenseData(userId, login, productDescriptor.getProductCode(), JetprofileSource.getBuildDate(), asset, decoded);
        }
        if (decoded.getUpgradeDueDate() == null) {
            return new JetProfileLicenseData(userId, login, asset, decoded);
        }
        return new JetProfileSubscriptionLicenseData(userId, login, asset, decoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        if (this.myLicenseFile.exists() && !this.myLicenseFile.isJProfileLicenseData()) {
            return;
        }
        boolean notityLicenseUpdated = false;
        try {
            JBALicenseData licenseFromSharedId;
            JBALicenseData restored = JetprofileSource.loadStoredLicenseInfo(this.factory);
            if ((restored == null || restored instanceof CertKeyLicense && restored.isExpired(new Date())) && (licenseFromSharedId = this.loadFromSharedUserId()) != null) {
                notityLicenseUpdated = true;
                restored = licenseFromSharedId;
                try {
                    this.save(restored);
                }
                catch (TargetSaveException targetSaveException) {
                    // empty catch block
                }
                this.storeAssetInfo(restored, false);
            }
            this.setLicense(restored);
            if (restored == null) {
                this.clearStoredLicenseInfo();
                this.myLogin = JetprofileSource.xorDecode(Prefs.get((String)JetprofileSource.getSharedUserLoginStorageKey(), null));
            } else {
                this.myLogin = restored.getUserLogin();
                this.scheduleRemoteValidation(this.getValidationPeriod());
            }
        }
        finally {
            JBALicenseData lic;
            this.myPassword = null;
            if (notityLicenseUpdated && (lic = this.getLicense()) != null) {
                LicenseEntryUtil.showLicenseProceedNotificationLater(lic);
            }
        }
    }

    @Override
    public void clear() {
        this.clearStoredLicenseInfo();
        Prefs.remove((String)JetprofileSource.getSharedUserIdStorageKey());
        Prefs.remove((String)JetprofileSource.getSharedUserLoginStorageKey());
        this.setLicense(null);
    }

    @Override
    public boolean hasCachedData() {
        return this.getLicense() != null || Prefs.getByteArray((String)JetprofileSource.getStorageKey(this.factory), null) != null;
    }

    @Override
    public boolean needNetworkLicenseCheck() {
        return true;
    }

    private ObtainLicenseResponse obtainLicense(String userId) throws IOException, VerificationFailedException {
        LicensingProxyService.getInstance();
        return JBAClientUtil.obtainLicenses(userId, this.getProductCode(), this.factory.getCurrentMajorVersion(), this.myEdition, this.myBuildDate);
    }

    private ValidateLicenseResponse validateLicense(String userId, String assetId, String licenseHash) throws IOException, VerificationFailedException {
        return JBAClientUtil.validateLicense(userId, assetId, licenseHash, this.getProductCode(), this.factory.getCurrentMajorVersion(), this.myEdition, this.myBuildDate);
    }

    @NotNull
    private static String obtainUserId(String login, String password) throws Exception {
        LicensingProxyService.getInstance();
        String errorMessage = "JetBrains Account communication error";
        IOException cause = null;
        if (login == null) {
            errorMessage = "JetBrains Account login name not specified";
        } else {
            ObtainUserIdResponse userIdResponse;
            block7: {
                userIdResponse = JBAClientUtil.obtainUserId(login, password == null ? "" : password);
                if (userIdResponse.getResponseCode() != ResponseCode.OK) break block7;
                String string2 = userIdResponse.getUserId();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/JetprofileSource", "obtainUserId"));
                }
                return string2;
            }
            try {
                errorMessage = "Authorization failed: " + userIdResponse.getMessage();
            }
            catch (IOException e2) {
                cause = e2;
                errorMessage = "JetBrains Account connection error: " + e2.getMessage();
            }
            catch (VerificationFailedException e3) {
                errorMessage = "JetBrains Account communication error: " + e3.getMessage();
            }
        }
        throw cause == null ? new Exception(errorMessage) : new IOException(errorMessage, cause);
    }

    @Nullable
    public String getLogin() {
        return this.myLogin;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void setLogin(String login) {
        this.myLogin = login;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    private static void updateSharedUserId(String userId, String login) {
        Prefs.put((String)JetprofileSource.getSharedUserIdStorageKey(), (String)JetprofileSource.xorEncode(userId));
        if (login != null) {
            Prefs.put((String)JetprofileSource.getSharedUserLoginStorageKey(), (String)JetprofileSource.xorEncode(login));
        }
    }

    @Nullable
    private JBALicenseData loadFromSharedUserId() {
        String userId = JetprofileSource.getSharedUserId();
        if (userId != null) {
            try {
                String login;
                List<JBALicenseData> licenses;
                ObtainLicenseResponse response = this.obtainLicense(userId);
                if (response.getResponseCode() == ResponseCode.OK && (licenses = this.createLicenses(JetprofileSource.xorDecode(login = Prefs.get((String)JetprofileSource.getSharedUserLoginStorageKey(), null)), userId, response.getAssets())).size() == 1) {
                    return licenses.iterator().next();
                }
            }
            catch (Throwable ignored) {
                LOG.info(ignored.getMessage());
            }
        }
        return null;
    }

    @Nullable
    public static String getSharedUserId() {
        String userId = Prefs.get((String)JetprofileSource.getSharedUserIdStorageKey(), null);
        return userId == null ? null : JetprofileSource.xorDecode(userId);
    }

    @Nullable
    public static String getSharedLogin() {
        String login = Prefs.get((String)JetprofileSource.getSharedUserLoginStorageKey(), null);
        return login == null ? null : JetprofileSource.xorDecode(login);
    }

    @Nullable
    public static JBALicenseData loadStoredLicenseInfo(LicenseFactory factory2) {
        try {
            byte[] data = Prefs.getByteArray((String)JetprofileSource.getStorageKey(factory2), null);
            if (data != null) {
                Properties properties = new Properties();
                properties.load(new InflaterInputStream(new ByteArrayInputStream(data)));
                String userId = properties.getProperty("user.id", null);
                if (userId == null) {
                    LOG.info("Corrupted JetProfile license data: user id missing");
                    return null;
                }
                String assetData = properties.getProperty("asset.data", null);
                if (assetData == null) {
                    LOG.info("Corrupted JetProfile license data: asset data missing");
                    return null;
                }
                return JetprofileSource.createLicenseData(properties.getProperty("user.login", null), userId, factory2.getProductDescriptor(), new EncodedAsset(assetData));
            }
        }
        catch (Throwable e2) {
            LOG.info("Error loading JetProfile license data: " + e2.getMessage());
        }
        return null;
    }

    private synchronized long getValidationStamp() {
        return Prefs.getLong((String)this.getStampStorageKey(), (long)0L);
    }

    private synchronized long getValidationPeriod() {
        return Prefs.getLong((String)this.getPeriodStorageKey(), (long)3600000L);
    }

    private synchronized long getValidationDeadlinePeriod() {
        return Prefs.getLong((String)this.getDeadlineStorageKey(), (long)-1L);
    }

    private synchronized void updateValidationPeriod(long period, long deadlinePeriod) {
        Prefs.putLong((String)this.getPeriodStorageKey(), (long)period);
        if (deadlinePeriod > 0L) {
            Prefs.putLong((String)this.getDeadlineStorageKey(), (long)deadlinePeriod);
        } else {
            Prefs.remove((String)this.getDeadlineStorageKey());
        }
    }

    private synchronized void updateValidationStamp(long stamp) {
        Prefs.putLong((String)this.getStampStorageKey(), (long)stamp);
    }

    private void storeAssetInfo(JBALicenseData licenseData, boolean verifyStoredData) {
        try {
            Properties properties = new Properties();
            properties.setProperty("user.id", licenseData.getUserId());
            String login = licenseData.getUserLogin();
            if (login != null) {
                properties.setProperty("user.login", login);
            }
            properties.setProperty("asset.data", licenseData.getEncodedAsset().getData());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DeflaterOutputStream zipStream = new DeflaterOutputStream(out);
            properties.store(zipStream, "JetProfile asset information. Please do not alter this data");
            zipStream.close();
            Prefs.putByteArray((String)JetprofileSource.getStorageKey(this.factory), (byte[])out.toByteArray());
            if (verifyStoredData) {
                byte[] data = Prefs.getByteArray((String)JetprofileSource.getStorageKey(this.factory), (byte[])EMPTY_BYTE_ARRAY);
                Properties verifyProperties = new Properties();
                verifyProperties.load(new InflaterInputStream(new ByteArrayInputStream(data)));
                if (verifyProperties.getProperty("user.id", null) == null || verifyProperties.getProperty("asset.data", null) == null) {
                    throw new Exception("License data was not saved (read-only access to java preferences?)"){

                        @Override
                        public synchronized Throwable fillInStackTrace() {
                            return this;
                        }
                    };
                }
            }
        }
        catch (Throwable e2) {
            LOG.info("Error saving JetProfile license data: " + e2.getMessage());
            throw new RuntimeException("Error storing asset information: " + e2.getMessage(), e2);
        }
    }

    private void clearStoredLicenseInfo() {
        Prefs.remove((String)this.getStampStorageKey());
        Prefs.remove((String)JetprofileSource.getStorageKey(this.factory));
        Prefs.remove((String)this.getPeriodStorageKey());
    }

    private static String getStorageKey(LicenseFactory factory2) {
        return "JetBrains.JetProfile.Asset." + factory2.getProductDescriptor().getProductCode();
    }

    private static String getSharedUserIdStorageKey() {
        return "JetBrains.JetProfile.UserId";
    }

    private static String getSharedUserLoginStorageKey() {
        return "JetBrains.JetProfile.UserLogin";
    }

    private String getStampStorageKey() {
        return JetprofileSource.getStorageKey(this.factory) + ".Stamp";
    }

    private String getPeriodStorageKey() {
        return JetprofileSource.getStorageKey(this.factory) + ".Period";
    }

    private String getDeadlineStorageKey() {
        return JetprofileSource.getStorageKey(this.factory) + ".Deadline";
    }

    @Override
    public JBALicenseData getLicense() {
        return this.myLicenseRef.get();
    }

    @Override
    public void setLicense(LicenseData license) {
        this.myLicenseRef.set((JBALicenseData)license);
        if (license == null) {
            this.cancelRemoteValidation();
        }
    }

    public List<JBALicenseData> getAvailableLicenses() {
        return this.myAvailableLicenses;
    }

    public void switchToLicence(JBALicenseData alternativeLicense) {
        List<JBALicenseData> availableLicenses = this.myAvailableLicenses;
        boolean found = false;
        for (JBALicenseData license : availableLicenses) {
            if (alternativeLicense != license) continue;
            found = true;
            break;
        }
        assert (found) : "The license to switch to must be contained in the list of available licenses";
        JBALicenseData oldLicense = this.myLicenseRef.getAndSet(alternativeLicense);
        if (alternativeLicense == null) {
            this.cancelRemoteValidation();
        } else if (alternativeLicense != oldLicense) {
            try {
                this.storeAssetInfo(alternativeLicense, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.scheduleRemoteValidation(this.getValidationPeriod());
        }
    }

    private static String xorEncode(String s2) {
        return s2 != null ? new String(Base64.getMimeEncoder().encode(JetprofileSource.xor(s2.getBytes(CHARSET))), CHARSET) : null;
    }

    private static String xorDecode(String s2) {
        return s2 != null ? new String(JetprofileSource.xor(Base64.getMimeDecoder().decode(s2.getBytes(CHARSET))), CHARSET) : null;
    }

    private static byte[] xor(byte[] str) {
        byte[] secret = SECRET;
        for (int i2 = 0; i2 < str.length; ++i2) {
            int n2 = i2;
            str[n2] = (byte)(str[n2] ^ secret[i2 % secret.length]);
        }
        return str;
    }

    private void cancelRemoteValidation() {
        ScheduledFuture<?> future2 = this.myPeriodicCheckFuture;
        if (future2 != null) {
            this.myPeriodicCheckFuture = null;
            future2.cancel(true);
        }
    }

    private void scheduleRemoteValidation(long validationPeriod) {
        this.cancelRemoteValidation();
        long effectivePeriod = validationPeriod <= 0L ? 3600000L : validationPeriod;
        this.myPeriodicCheckFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            try {
                Application app;
                JBALicenseData license = this.getLicense();
                if (license != null && (app = ApplicationManager.getApplication()) != null) {
                    app.executeOnPooledThread((Runnable)new ValidateLicenseTask(license, validationPeriod));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, this.myFirstCheckPerformed ? effectivePeriod : 600000L, effectivePeriod, TimeUnit.MILLISECONDS);
    }

    private class ValidateLicenseTask
    implements Runnable {
        @NotNull
        private final JBALicenseData myLicenseData;
        private final long myValidationPeriod;

        public ValidateLicenseTask(JBALicenseData licenseData, long validationPeriod) {
            if (licenseData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseData", "com/intellij/ide/license/impl/JetprofileSource$ValidateLicenseTask", "<init>"));
            }
            this.myLicenseData = licenseData;
            this.myValidationPeriod = validationPeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (myOnlineValidationInProgress.getAndSet(true)) {
                return;
            }
            try {
                Application app = ApplicationManager.getApplication();
                if (app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
                    return;
                }
                if (app.isDisposeInProgress() || app.isDisposed()) {
                    return;
                }
                JBALicenseData currentLicenseData = JetprofileSource.this.getLicense();
                if (currentLicenseData == null || !Comparing.equal((String)currentLicenseData.getLicenseId(), (String)this.myLicenseData.getLicenseId())) {
                    return;
                }
                JetprofileSource.this.myFirstCheckPerformed = true;
                Action action2 = Action.NONE;
                String problemReason = "";
                long lastTimeValidated = JetprofileSource.this.getValidationStamp();
                long timePassedSinceLastCheck = System.currentTimeMillis() - lastTimeValidated;
                long currentDeadlinePeriod = JetprofileSource.this.getValidationDeadlinePeriod();
                try {
                    boolean validationPeriodUpdated;
                    String licenseHash = this.myLicenseData instanceof CertKeyLicense ? ((CertKeyLicense)((Object)this.myLicenseData)).getCertKey().getHash() : "";
                    ValidateLicenseResponse response = JetprofileSource.this.validateLicense(this.myLicenseData.getUserId(), this.myLicenseData.getLicense().getAssetId(), licenseHash);
                    long newValidationPeriod = this.myValidationPeriod;
                    long newDeadlinePeriod = currentDeadlinePeriod;
                    if (response.getResponseCode() == ResponseCode.OK) {
                        String newAsset;
                        JetprofileSource.this.updateValidationStamp(System.currentTimeMillis());
                        newValidationPeriod = response.getValidationPeriod();
                        newDeadlinePeriod = response.getValidationDeadlinePeriod();
                        if (newValidationPeriod < 0L) {
                            newValidationPeriod = 3600000L;
                        }
                        if ((newAsset = response.getNewEncodedAsset()) != null) {
                            try {
                                JBALicenseData newLicenseData = JetprofileSource.createLicenseData(this.myLicenseData.getUserLogin(), this.myLicenseData.getUserId(), JetprofileSource.this.factory.getProductDescriptor(), new EncodedAsset(newAsset));
                                if (JetprofileSource.this.myLicenseRef.compareAndSet(this.myLicenseData, newLicenseData)) {
                                    JetprofileSource.this.storeAssetInfo(newLicenseData, false);
                                    JetprofileSource.this.myLicenseManager.scheduleLicenseExpirationCheckNow();
                                }
                            }
                            catch (Throwable e2) {
                                LOG.info(e2.getMessage());
                            }
                        }
                    } else {
                        boolean isError = response.getResponseCode() == ResponseCode.ERROR;
                        problemReason = response.getMessage();
                        if (response.getResponseCode() == ResponseCode.SERVER_INTERNAL_ERROR) {
                            newValidationPeriod = 3600000L;
                        }
                        if (isError) {
                            Action _action = response.getAction();
                            action2 = _action != null ? _action : Action.REVOKE;
                        }
                    }
                    boolean bl = validationPeriodUpdated = this.myValidationPeriod != newValidationPeriod;
                    if (validationPeriodUpdated || currentDeadlinePeriod != newDeadlinePeriod) {
                        JetprofileSource.this.updateValidationPeriod(newValidationPeriod, newDeadlinePeriod);
                        if (validationPeriodUpdated) {
                            JetprofileSource.this.scheduleRemoteValidation(newValidationPeriod);
                        }
                    }
                }
                catch (IOException ignored) {
                    if (currentDeadlinePeriod > 0L) {
                        if (timePassedSinceLastCheck >= currentDeadlinePeriod) {
                            action2 = Action.REVOKE;
                            problemReason = "Unable to contact your JetBrains account.";
                        } else {
                            long timeLeftUntilDeadline = currentDeadlinePeriod - timePassedSinceLastCheck;
                            if (timeLeftUntilDeadline <= 604800000L) {
                                boolean shouldWarn;
                                long lastTimeWarned = JetprofileSource.this.myLastOfflineWarningStamp;
                                long now = System.currentTimeMillis();
                                boolean bl = shouldWarn = lastTimeWarned < 0L || now - lastTimeWarned >= 172800000L;
                                if (shouldWarn) {
                                    LicenseEntryUtil.showLicenseNotificationLater("License Validation", "Unable to contact your JetBrains account.\nPlease make sure Internet connection is available no later than " + DateFormatUtil.formatDate((long)(lastTimeValidated + currentDeadlinePeriod)), NotificationType.WARNING);
                                    JetprofileSource.this.myLastOfflineWarningStamp = now;
                                }
                            }
                        }
                    }
                }
                catch (VerificationFailedException e3) {
                    action2 = Action.REVOKE;
                    problemReason = e3.getMessage();
                }
                if (action2 == Action.REVOKE) {
                    if (JetprofileSource.this.myLicenseRef.compareAndSet(this.myLicenseData, null)) {
                        JetprofileSource.this.cancelRemoteValidation();
                        JetprofileSource.this.clearStoredLicenseInfo();
                        JetprofileSource.this.myLicenseManager.askUserForLicense(new LicenseManager.StartupAction(){

                            @Override
                            public void cancel() {
                                GeneralLicenseManager.shutdownApplication();
                            }

                            @Override
                            public boolean cancelMeansShutdown() {
                                return true;
                            }
                        }, JetprofileSource.this, problemReason);
                    }
                } else if (action2 == Action.WARN) {
                    LicenseEntryUtil.showLicenseNotificationLater("License Validation", problemReason, NotificationType.WARNING);
                }
            }
            catch (Throwable e4) {
                LOG.debug("Unexpected error checking online license: ", e4);
            }
            finally {
                myOnlineValidationInProgress.set(false);
            }
        }
    }
}

