/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseMessages;
import com.intellij.ide.license.impl.EvaluationLicenseData;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.io.FileUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LicenseFactoryImpl
implements LicenseFactory {
    private final LicenseMessages messages;

    public LicenseFactoryImpl(LicenseMessages messages) {
        this.messages = messages;
    }

    public static int getInternalVersionNumber(int baseLineVersion) {
        return 2000000 + baseLineVersion * 100;
    }

    @Override
    public LicenseMessages getLicenseMessages() {
        return this.messages;
    }

    @Override
    public ServerLicenseData createServerLicense(String ticketId, long prolongationPeriod, String serverUrl, String licensee, int licenseType, Date maintenanceDueDate) {
        return new ServerLicenseData(ticketId, prolongationPeriod, serverUrl, licensee, licenseType, maintenanceDueDate);
    }

    @Override
    @Nullable
    public LicenseData findExistingEvaluationLicense() {
        File evalLicenseFile = this.evalLicenseFile();
        if (evalLicenseFile.exists()) {
            try {
                DataInputStream stream = new DataInputStream(new FileInputStream(evalLicenseFile));
                long date = stream.readLong() ^ 0xFFFFFFFFFFFFFFFFL;
                stream.close();
                return this.createEvaluationLicenseData(date);
            }
            catch (IOException e2) {
                return null;
            }
        }
        return null;
    }

    protected abstract EvaluationLicenseData createEvaluationLicenseData(long var1);

    @Override
    @NotNull
    public EvaluationLicenseData createEvaluationLicense() {
        long currentTime = new Date().getTime();
        EvaluationLicenseData evaluationLicenseData = this.createEvaluationLicenseData(currentTime);
        if (evaluationLicenseData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseFactoryImpl", "createEvaluationLicense"));
        }
        return evaluationLicenseData;
    }

    @Override
    public boolean storeEvaluationLicense(EvaluationLicenseData license) {
        try {
            File file2 = this.evalLicenseFile();
            FileUtil.createIfDoesntExist((File)file2);
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(file2));
            stream.writeLong(license.getGenerationDate().getTime() ^ 0xFFFFFFFFFFFFFFFFL);
            stream.close();
            return true;
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(null, "Error saving evaluation license: " + e2.getMessage());
            return false;
        }
    }

    protected File evalLicenseFile() {
        ApplicationInfoEx app_info = LicenseFactoryImpl.getAppInfo();
        String eval_id = app_info.isEAP() && !this.isForceReleaseEvaluationSelector() ? app_info.getBuild().asString() : this.getCurrentEvaluationSelector();
        return new File(PathManager.getConfigPath() + File.separator + "eval" + File.separator + this.getProductDescriptor().getShortName() + eval_id + ".evaluation.key");
    }

    protected static ApplicationInfoEx getAppInfo() {
        return ApplicationInfoImpl.getShadowInstance();
    }

    @NotNull
    protected Date getProductBuildDate() {
        Calendar date = LicenseFactoryImpl.getAppInfo().getMajorReleaseBuildDate();
        Date date2 = date.getTime();
        if (date2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseFactoryImpl", "getProductBuildDate"));
        }
        return date2;
    }
}

