/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseCreationException;
import com.intellij.ide.license.ProductDescriptor;
import com.intellij.ide.license.impl.CertKeyLicenseData;
import com.intellij.ide.license.impl.JBALicenseData;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.ide.license.impl.TargetSaveException;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.license.LicenseDataImpl;
import com.intellij.licensecommon.license.LicenseInfoDecoder;
import com.intellij.licensecommon.license.SubscriptionLicenseDataImpl;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LicenseFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.license.impl.LicenseFile");
    private static final String JET_PROFILE_DATA_MARKER = "JetProfile";
    protected static final String CERT_KEY_SIGNATURE = "<certificate-key>\n";
    protected static final String SUBSCRIPTION_SIGNATURE = "<subscription>\n";
    @NotNull
    private final ProductDescriptor myProductDescriptor;
    protected final String myReadPath;
    private final String myWritePath;
    private static final String URL_PREFIX = "URL:";

    protected LicenseFile(@NotNull ProductDescriptor productDescriptor, String readPath, String writePath) {
        if (productDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productDescriptor", "com/intellij/ide/license/impl/LicenseFile", "<init>"));
        }
        this.myProductDescriptor = productDescriptor;
        this.myReadPath = readPath;
        this.myWritePath = writePath;
    }

    public boolean exists() {
        return new File(this.myWritePath).exists();
    }

    public boolean delete() {
        return FileUtil.delete((File)new File(this.myWritePath));
    }

    public void save(LicenseData license) throws TargetSaveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing license data...");
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(this.myWritePath);
            ((OutputStream)out).write(255);
            ((OutputStream)out).write(255);
            if (license instanceof ServerLicenseData) {
                LicenseFile.writeString(out, URL_PREFIX + ((ServerLicenseData)license).getServerUrl());
            } else if (license instanceof JBALicenseData) {
                LicenseFile.writeString(out, JET_PROFILE_DATA_MARKER);
            } else {
                this.writeLicenseData(license, out);
            }
            out.flush();
        }
        catch (Exception e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("error writing license data:" + e2.getMessage());
            }
            throw new TargetSaveException(e2);
        }
    }

    protected abstract void writeLicenseData(LicenseData var1, OutputStream var2) throws IOException;

    protected static void writeString(OutputStream out, String s2) throws IOException {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            byte b0 = (byte)(c2 & 0xFF);
            byte b1 = (byte)(c2 >> 8 & 0xFF);
            out.write(b0);
            out.write(b1);
        }
    }

    @Nullable
    public LicenseData getLicense() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\"reading license data...\"");
        }
        try {
            LicenseData licenseData = this.parseLicenseData(this.readFile());
            if (LOG.isDebugEnabled()) {
                LOG.debug("read license data:" + (licenseData != null ? "\"" + licenseData.getUserName() + "\",\"" + licenseData.getKey() + "\"" : "null"));
            }
            return licenseData;
        }
        catch (IOException e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable to read license data...");
            }
            return null;
        }
    }

    @Nullable
    public ServerLicenseData readServerLicenseData() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\"reading license data...\"");
        }
        try {
            ServerLicenseData licenseData = this.parseServerLicenseData(this.readFile());
            if (LOG.isDebugEnabled()) {
                LOG.debug("read license data:" + (licenseData != null ? "\"" + licenseData.getServerUrl() + "\",\"" + licenseData.isAccepted() + "\"" : "null"));
            }
            return licenseData;
        }
        catch (IOException e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable to read license data...");
            }
            return null;
        }
    }

    public boolean isJProfileLicenseData() {
        try {
            return JET_PROFILE_DATA_MARKER.equals(this.readFile());
        }
        catch (IOException e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable to read license data...");
            }
            return false;
        }
    }

    @Nullable
    protected static Pair<String, String> parseUserKeyPair(String text2) {
        StringTokenizer tokenizer = new StringTokenizer(text2, "\r\n");
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String key = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String userName = tokenizer.nextToken();
        if (userName == null || key == null) {
            return null;
        }
        return Pair.create((Object)userName, (Object)key);
    }

    protected static boolean isServerUrlStoredInOldFormat(@NotNull String key, @NotNull String userName) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/license/impl/LicenseFile", "isServerUrlStoredInOldFormat"));
        }
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "com/intellij/ide/license/impl/LicenseFile", "isServerUrlStoredInOldFormat"));
        }
        return userName.contains("License") && userName.contains("Server") && key.contains("http");
    }

    @Nullable
    protected abstract LicenseData parseLicenseData(String var1);

    @Nullable
    protected ServerLicenseData parseServerLicenseData(String text2) {
        StringTokenizer tokenizer = new StringTokenizer(text2, "\r\n");
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String serverUrl = tokenizer.nextToken();
        if (serverUrl != null && serverUrl.startsWith(URL_PREFIX)) {
            return ServerLicenseData.restoreFromFile(serverUrl.substring(URL_PREFIX.length()));
        }
        return this.restoreUrlFromOldFormat(text2);
    }

    @Nullable
    private ServerLicenseData restoreUrlFromOldFormat(String text2) {
        Pair<String, String> data = LicenseFile.parseUserKeyPair(text2);
        if (data == null) {
            return null;
        }
        String name = (String)data.getFirst();
        String key = (String)data.getSecond();
        if (!LicenseFile.isServerUrlStoredInOldFormat(key, name)) {
            return null;
        }
        return ServerLicenseData.restoreFromFile(key);
    }

    private String readFile() throws IOException {
        if (this.isNewFormat()) {
            return this.readNewFormat();
        }
        return this.readOldFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewFormat() throws IOException {
        try (InputStream in = null;){
            in = this.openAsStream();
            int b0 = in.read();
            int b1 = in.read();
            boolean bl = b0 == 255 && b1 == 255;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNewFormat() throws IOException {
        try (InputStream in = null;){
            in = this.openAsStream();
            int b0 = in.read();
            int b1 = in.read();
            StringBuffer buffer = new StringBuffer();
            while ((b0 = in.read()) != -1 && (b1 = in.read()) != -1) {
                buffer.append((char)((b1 << 8) + b0));
            }
            String string2 = buffer.toString();
            return string2;
        }
    }

    private String readOldFormat() throws IOException {
        return FileUtil.loadFile((File)new File(this.myReadPath));
    }

    private InputStream openAsStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.myReadPath));
    }

    protected void writeCertKeyLicense(LicenseData license, OutputStream out) throws IOException {
        LicenseFile.writeString(out, license.getKey());
    }

    protected void writeLegacySubscriptionLicense(LicenseData license, OutputStream out) throws IOException {
        LicenseFile.writeString(out, license.getUserName());
        LicenseFile.writeString(out, "\n");
        LicenseFile.writeString(out, license.getKey());
    }

    protected void writeLegacyLicense(LicenseData license, OutputStream out) throws IOException {
        LicenseFile.writeString(out, license.getKey());
        LicenseFile.writeString(out, "\n");
        LicenseFile.writeString(out, license.getUserName());
    }

    protected CertKeyLicenseData readCertKeyLicense(String text2) {
        try {
            Date buildDate = ApplicationInfoImpl.getShadowInstance().getMajorReleaseBuildDate().getTime();
            return new CertKeyLicenseData(text2, this.myProductDescriptor.getProductCode(), buildDate);
        }
        catch (LicenseCreationException e2) {
            String details = e2.getDetails();
            StringBuilder msg = new StringBuilder(e2.getMessage());
            if (details != null) {
                msg.append(": ").append(details);
            }
            LOG.info(msg.toString());
            return null;
        }
    }

    protected SubscriptionLicenseDataImpl readLegacySubscriptionLicense(String text2, LicenseInfoDecoder<SubscriptionLicenseInfo> decoder) {
        StringTokenizer tokenizer = new StringTokenizer(text2, "\r\n");
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String userName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        StringBuilder keyBuilder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            if (keyBuilder.length() > 0) {
                keyBuilder.append("\n");
            }
            keyBuilder.append(tokenizer.nextToken());
        }
        String key = keyBuilder.toString();
        if (LicenseFile.isServerUrlStoredInOldFormat(userName, key)) {
            return null;
        }
        return new SubscriptionLicenseDataImpl(key, userName, decoder);
    }

    @Nullable
    protected LicenseDataImpl readLegacyLicense(String text2) {
        Pair<String, String> pair = LicenseFile.parseUserKeyPair(text2);
        if (pair == null) {
            return null;
        }
        String name = (String)pair.getFirst();
        String key = (String)pair.getSecond();
        if (LicenseFile.isServerUrlStoredInOldFormat(key, name)) {
            return null;
        }
        return new LicenseDataImpl(key, name);
    }
}

