/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.intellij.ide.license.LicenseFactory;
import com.intellij.ide.license.LicenseTarget;
import com.intellij.ide.license.impl.GeneralLicenseManager;
import com.intellij.ide.license.impl.LicenseFile;
import com.intellij.ide.license.impl.LicensingProxyService;
import com.intellij.ide.license.impl.NoFreeTicketException;
import com.intellij.ide.license.impl.ServerConnectionException;
import com.intellij.ide.license.impl.ServerLicenseData;
import com.intellij.ide.license.impl.ServerProtocolHijacked;
import com.intellij.ide.license.impl.ServerSource;
import com.intellij.ide.license.impl.TargetSaveException;
import com.intellij.licensecommon.license.LicenseData;
import com.intellij.licensecommon.util.SubscriptionVersion;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.ls.responses.GetPermanentActivationResponse;
import com.jetbrains.ls.responses.ObtainPermanentTicketResponse;
import com.jetbrains.ls.responses.ObtainTicketResponse;
import com.jetbrains.ls.responses.ProlongTicketResponse;
import com.jetbrains.ls.responses.ReleaseTicketResponse;
import com.jetbrains.ls.responses.ResponseCode;
import com.jetbrains.ls.util.ClientUtil;
import com.jetbrains.ls.util.FloatingClientUtil;
import com.jetbrains.ls.util.VerificationFailedException;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseServerSource
extends ServerSource
implements LicenseTarget {
    private static final Logger LOG = Logger.getInstance((String)"#ServerLicenseSource");
    private final int myEncodedBuildDate;
    private final boolean mySendBuildDateAsVersionToOldServers;
    private final LicenseFile myLicenseFile;
    private static final String[] URL_BLACKLIST_PATTERNS = new String[]{".*\\.lanyus\\..*", ".*\\.5ztx\\..*", ".*\\.qinxi1992\\..*", ".*114\\.215\\.133\\.70\\:41017.*", ".*dedsec\\..*", ".*license-server\\.tk\\:.*", ".*mcpmcc\\..*", ".*idea\\.pjoc\\.pub.*", ".*idea\\.329528\\.pw.*", ".*diy-cia48621793\\.rhcloud\\.com.*", ".*v2mc\\.net\\:.*", ".*\\.h4ck\\.ws\\:.*", ".*jetbrains(?:.*)\\.tencent(?:.*)\\.click.*"};

    public LicenseServerSource(@NotNull LicenseFactory factory2, GeneralLicenseManager manager) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/ide/license/impl/LicenseServerSource", "<init>"));
        }
        this(factory2, manager, factory2.getCurrentMajorVersion(), false);
    }

    private LicenseServerSource(@NotNull LicenseFactory factory2, GeneralLicenseManager manager, int productVersion, boolean sendBuildDateAsVersionToOldServers) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/ide/license/impl/LicenseServerSource", "<init>"));
        }
        super(factory2, productVersion, manager);
        this.mySendBuildDateAsVersionToOldServers = sendBuildDateAsVersionToOldServers;
        this.myEncodedBuildDate = SubscriptionVersion.createVersion(ApplicationInfoImpl.getShadowInstance().getMajorReleaseBuildDate().getTime());
        this.myLicenseFile = factory2.getLicenseFile();
    }

    @Override
    protected String getMachineId() {
        return ClientUtil.getMachineId();
    }

    @Override
    protected String getLicenseePropertyName() {
        return "licensee";
    }

    @Override
    protected String getMaintenanceDuePropertyName() {
        return "maintenanceDue";
    }

    @Override
    protected String getLicenseTypePropertyName() {
        return "licenseType";
    }

    @Override
    public void restore() {
        ServerLicenseData restored = this.myLicenseFile.readServerLicenseData();
        if (restored == null) {
            return;
        }
        String url = restored.getServerUrl();
        if (url == null) {
            return;
        }
        this.setServerUrl(url);
        super.restore();
    }

    @Override
    public void clear() {
        ServerLicenseData license = this.getLicense();
        String url = null;
        String ticketId = null;
        boolean permanent = false;
        if (license != null) {
            url = license.getServerUrl();
            ticketId = license.getTicketId();
            permanent = license.isPermanent();
        }
        this.deleteStoredTicketInfo(url, ticketId, permanent);
        this.setLicense(null);
    }

    @Override
    protected void storeTicketInfo(ServerLicenseData license) {
        try {
            this.save(license);
        }
        catch (TargetSaveException targetSaveException) {
            // empty catch block
        }
        super.storeTicketInfo(license);
    }

    @Override
    public void save(LicenseData license) throws TargetSaveException {
        this.myLicenseFile.save(license);
    }

    @Nullable
    public ServerLicenseData obtainPermanentLicenseFromServer() {
        GetPermanentActivationResponse activationResponse;
        ServerLicenseData serverLicense = this.getLicense();
        if (serverLicense == null) {
            return null;
        }
        String url = serverLicense.getServerUrl();
        String email = Messages.showInputDialog((String)"Enter valid E-Mail address to send the activation code to", (String)"Enter E-Mail Address", (Icon)Messages.getQuestionIcon());
        if (email == null) {
            return null;
        }
        try {
            LicenseServerSource.checkUrlAllowed(url);
            activationResponse = FloatingClientUtil.obtainPermanentActivationCode(url, this.getProductFamilyUUID(), email);
        }
        catch (VerificationFailedException e2) {
            LicenseServerSource.showError("Problem connecting to the server", "Cannot obtain permanent ticket. Server protocol incompatible or hijacked: " + e2.getMessage());
            return null;
        }
        catch (IOException e3) {
            LicenseServerSource.showError("IO Problem", "Cannot obtain permanent ticket due to connectivity problem: " + e3.getLocalizedMessage());
            return null;
        }
        ResponseCode okCode = activationResponse.getResponseCode();
        if (okCode == ResponseCode.ERROR) {
            LicenseServerSource.showError("Permanent Ticket Issue Refused", "Server refused to issue the ticket: " + activationResponse.getMessage());
            return null;
        }
        String activationCode = Messages.showInputDialog((String)("The activation code has been mailed to " + email + ". Paste it into the field below and press OK."), (String)"Enter Activation Code", (Icon)Messages.getQuestionIcon());
        if (activationCode == null) {
            return null;
        }
        ObtainPermanentTicketResponse ticketResponse = this.obtainPermanentTicket(this.getServerUrl(), email, activationCode);
        if (ticketResponse == null) {
            return null;
        }
        if (ticketResponse.getResponseCode() == ResponseCode.ERROR) {
            LicenseServerSource.showError("Permanent Ticket Issue Refused", "Server refused to issue the ticket: " + ticketResponse.getMessage());
            return null;
        }
        Messages.showInfoMessage((String)"Permanent ticket successfully issued", (String)"Permanent Ticket Received");
        this.updateLicenseStamp();
        long prolongation = serverLicense.getProlongationPeriod();
        this.stopProlongTask();
        ServerLicenseData created = this.createLicenseData(url, ticketResponse.getTicketId(), prolongation, ticketResponse.parseTicketProperties());
        created.setPermanent(true);
        this.setLicense(created);
        this.startProlongTask(created);
        return created;
    }

    @Override
    @NotNull
    protected ServerSource.ProlongationCode prolongServerLicense(ServerLicenseData serverLicense) {
        ServerSource.ProlongationCode prolongationCode;
        String serverUrl;
        block9: {
            serverUrl = serverLicense.getServerUrl();
            LicenseServerSource.checkUrlAllowed(serverUrl);
            ProlongTicketResponse response = FloatingClientUtil.prolongTicket(serverUrl, serverLicense.getTicketId(), this.getProductFamilyUUID());
            if (response.getResponseCode() == ResponseCode.OK) break block9;
            ServerSource.ProlongationCode prolongationCode2 = ServerSource.ProlongationCode.REFUSED;
            if (prolongationCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseServerSource", "prolongServerLicense"));
            }
            return prolongationCode2;
        }
        try {
            prolongationCode = ServerSource.ProlongationCode.OK;
        }
        catch (VerificationFailedException e2) {
            ServerSource.ProlongationCode prolongationCode3 = ServerSource.ProlongationCode.REFUSED;
            if (prolongationCode3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseServerSource", "prolongServerLicense"));
            }
            return prolongationCode3;
        }
        catch (Throwable e3) {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("Error prolonging ticket ").append(serverLicense.getTicketId()).append(" with ").append(serverUrl).append(": ");
            logMessage.append(e3.getClass().getName());
            String message2 = e3.getMessage();
            if (message2 != null) {
                logMessage.append(": ").append(message2);
            }
            LOG.info(logMessage.toString());
            ServerSource.ProlongationCode prolongationCode4 = ServerSource.ProlongationCode.DISCONNECTED;
            if (prolongationCode4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseServerSource", "prolongServerLicense"));
            }
            return prolongationCode4;
        }
        if (prolongationCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseServerSource", "prolongServerLicense"));
        }
        return prolongationCode;
    }

    @Override
    protected boolean releaseServerLicense(String serverUrl, String ticketId) {
        if (serverUrl == null || ticketId == null) {
            return false;
        }
        try {
            ReleaseTicketResponse response = FloatingClientUtil.releaseTicket(serverUrl, ticketId, this.getProductFamilyUUID());
            return response.getResponseCode() == ResponseCode.OK;
        }
        catch (VerificationFailedException e2) {}
        finally {
            return false;
        }
    }

    boolean ping(String serverUrl) {
        try {
            LicenseServerSource.checkUrlAllowed(serverUrl);
            return FloatingClientUtil.pingFloating(serverUrl, this.getProductFamilyUUID()).getResponseCode() == ResponseCode.OK;
        }
        catch (VerificationFailedException e2) {
            return false;
        }
        catch (IOException e3) {
            return false;
        }
    }

    @Override
    @NotNull
    protected ServerLicenseData obtainTicketFromServer(String serverUrl) throws NoFreeTicketException, ServerConnectionException, ServerProtocolHijacked {
        ObtainTicketResponse response;
        block7: {
            LicenseServerSource.checkUrlAllowed(serverUrl);
            response = FloatingClientUtil.obtainTicket(serverUrl, this.getProductFamilyUUID(), this.getProductVersion(), this.myEncodedBuildDate, this.mySendBuildDateAsVersionToOldServers);
            if (response.getResponseCode() != ResponseCode.OK) break block7;
            ServerLicenseData serverLicenseData = this.createLicenseData(serverUrl, response.getTicketId(), response.getProlongationPeriod(), response.parseTicketProperties());
            if (serverLicenseData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicenseServerSource", "obtainTicketFromServer"));
            }
            return serverLicenseData;
        }
        try {
            throw new NoFreeTicketException(response.getMessage());
        }
        catch (NoFreeTicketException e2) {
            throw new NoFreeTicketException(e2.getMessage());
        }
        catch (VerificationFailedException e3) {
            String message2 = e3.getMessage();
            throw message2 != null ? new ServerProtocolHijacked(message2) : new ServerProtocolHijacked();
        }
        catch (IOException e4) {
            throw new ServerConnectionException("Cannot obtain ticket from " + serverUrl + " due to connectivity problem: " + e4.getMessage(), e4.getClass().getName());
        }
        catch (Throwable e5) {
            throw new ServerConnectionException("Cannot obtain ticket from " + serverUrl + ": " + e5.getMessage(), e5.getClass().getName());
        }
    }

    @Nullable
    protected ObtainPermanentTicketResponse obtainPermanentTicket(String url, String email, String activationCode) {
        try {
            LicenseServerSource.checkUrlAllowed(url);
            return FloatingClientUtil.obtainPermanentTicket(url, this.getProductFamilyUUID(), this.getProductVersion(), this.myEncodedBuildDate, this.mySendBuildDateAsVersionToOldServers, email, activationCode);
        }
        catch (VerificationFailedException e2) {
            LicenseServerSource.showError("Problem connecting to the server", "Cannot obtain permanent ticket. Server protocol incompatible or hijacked: " + e2.getMessage());
            return null;
        }
        catch (Throwable e3) {
            LicenseServerSource.showError("IO Problem", "Cannot obtain permanent ticket due to connectivity problem: " + e3.getLocalizedMessage());
            return null;
        }
    }

    public void releasePermanentLicense() {
        ServerLicenseData data = this.getLicense();
        if (data == null) {
            return;
        }
        String serverUrl = data.getServerUrl();
        boolean ok = this.releaseServerLicense(serverUrl, data.getTicketId());
        if (!ok) {
            LicenseServerSource.showError("No Valid Response from Server", "License server doesn't respond or refuses to return license to the pool");
            return;
        }
        this.deleteStoredTicketInfo(serverUrl, data.getTicketId(), true);
        this.stopProlongTask();
        this.reobtainFloatingTicket(serverUrl, false);
        Messages.showInfoMessage((String)"Permanent ticket successfully released. Floating license obtained.", (String)"Permanent Ticket Released");
    }

    private static void checkUrlAllowed(String url) throws VerificationFailedException {
        LicensingProxyService.getInstance();
        for (String pattern : URL_BLACKLIST_PATTERNS) {
            try {
                if (!Pattern.compile(pattern, 2).matcher(url).matches()) continue;
                throw new VerificationFailedException(){

                    @Override
                    public synchronized Throwable fillInStackTrace() {
                        return this;
                    }
                };
            }
            catch (VerificationFailedException e2) {
                throw e2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

