/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.license.impl;

import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.util.PlatformUtil;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.NonStaticAuthenticator;
import com.intellij.util.proxy.SharedProxyConfig;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicensingProxyService {
    private static final Logger LOG = Logger.getInstance((String)"#InitialProxyService");
    private static final String SERVICE_ID = "jba.proxy.detect.service";
    @Nullable
    private Pair<String, String> myProxyConfig;
    @Nullable
    private Pair<String, String> myDiscoveredConfig;
    @Nullable
    private Pair<String, char[]> myProxyAuth;
    private volatile boolean myUseAutodiscoveredConfig = true;
    private final AtomicNotNullLazyValue<ProxySelector> mySelectorRef = new AtomicNotNullLazyValue<ProxySelector>(){

        @NotNull
        protected ProxySelector compute() {
            ArrayList<ProxySearch.Strategy> availableStrategies = new ArrayList<ProxySearch.Strategy>(5);
            if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
                availableStrategies.add(ProxySearch.Strategy.IE);
                availableStrategies.add(ProxySearch.Strategy.FIREFOX);
            }
            availableStrategies.add(ProxySearch.Strategy.OS_DEFAULT);
            availableStrategies.add(ProxySearch.Strategy.ENV_VAR);
            SmartList selectors = new SmartList();
            for (ProxySearch.Strategy strategy : availableStrategies) {
                try {
                    ProxySearch proxySearch = new ProxySearch();
                    proxySearch.addStrategy(strategy);
                    ProxySelector selector = proxySearch.getProxySelector();
                    if (selector == null) continue;
                    selectors.add(selector);
                }
                catch (Throwable e2) {
                    LOG.info(e2.getClass().getName() + ": " + e2.getMessage());
                }
            }
            CompoundProxySelector compoundProxySelector = new CompoundProxySelector((List<ProxySelector>)selectors);
            if (compoundProxySelector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/license/impl/LicensingProxyService$1", "compute"));
            }
            return compoundProxySelector;
        }
    };

    private LicensingProxyService() {
        CommonProxy.getInstance().setCustom(SERVICE_ID, new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri2) {
                if (LicensingProxyService.isActive()) {
                    return ((ProxySelector)LicensingProxyService.this.mySelectorRef.getValue()).select(uri2);
                }
                LicensingProxyService.this.unregisterCustomSelector();
                return Collections.emptyList();
            }

            @Override
            public void connectFailed(URI uri2, SocketAddress sa, IOException ioe) {
                if (LicensingProxyService.isActive()) {
                    ((ProxySelector)LicensingProxyService.this.mySelectorRef.getValue()).connectFailed(uri2, sa, ioe);
                } else {
                    LicensingProxyService.this.unregisterCustomSelector();
                }
            }
        });
        CommonProxy.getInstance().setCustomAuth(SERVICE_ID, (NonStaticAuthenticator)new LicensingProxyAuthenticator());
    }

    public static boolean isActive() {
        return !IdeaApplication.isLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterCustomSelector() {
        CommonProxy commonProxy = CommonProxy.getInstance();
        commonProxy.removeCustom(SERVICE_ID);
        commonProxy.removeCustomAuth(SERVICE_ID);
        LicensingProxyService licensingProxyService = this;
        synchronized (licensingProxyService) {
            this.myProxyAuth = null;
            this.myProxyConfig = null;
            this.myDiscoveredConfig = null;
        }
    }

    public static LicensingProxyService getInstance() {
        return InstanceHolder.ourInstance;
    }

    public void setUserDefinedProxy(String host, String port) {
        this.setUserDefinedProxy(host, port, null);
    }

    public synchronized void setUserDefinedProxy(String host, String port, @Nullable Pair<String, char[]> auth) {
        Pair<String, String> cfg = LicensingProxyService.getPair(host, port);
        if (!Comparing.equal(this.myProxyConfig, cfg) || !Comparing.equal(this.myProxyAuth, auth)) {
            this.myUseAutodiscoveredConfig = false;
            this.myProxyConfig = cfg;
            this.myDiscoveredConfig = null;
            this.myProxyAuth = auth;
            this.updateSharedProxyData();
        }
    }

    @Nullable
    private static Pair<String, String> getPair(@Nullable String host, @Nullable String port) {
        return StringUtil.isEmptyOrSpaces((String)host) || StringUtil.isEmptyOrSpaces((String)port) ? null : Pair.create((Object)host.trim(), (Object)port.trim());
    }

    @Nullable
    private static Pair<String, String> getPair(@Nullable String host, int port) {
        return LicensingProxyService.getPair(host, String.valueOf(port));
    }

    @Nullable
    private static Pair<String, char[]> getPair(@Nullable String login, @NotNull char[] password) {
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/ide/license/impl/LicensingProxyService", "getPair"));
        }
        return StringUtil.isEmptyOrSpaces((String)login) ? null : Pair.create((Object)login.trim(), (Object)password);
    }

    private void updateSharedProxyData() {
        try {
            Pair<String, String> hostPort = this.getProxyConfig();
            if (hostPort != null) {
                Pair<String, char[]> auth = this.getProxyAuth();
                String login = auth != null ? (String)auth.first : null;
                char[] password = auth != null ? (char[])auth.second : new char[]{};
                SharedProxyConfig.store((SharedProxyConfig.ProxyParameters)new SharedProxyConfig.ProxyParameters((String)hostPort.first, Integer.parseInt((String)hostPort.second), login, password));
            } else {
                SharedProxyConfig.clear();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Nullable
    public synchronized Pair<String, String> getProxyConfig() {
        return this.myProxyConfig;
    }

    @Nullable
    public synchronized Pair<String, char[]> getProxyAuth() {
        return this.myProxyAuth;
    }

    @Nullable
    public synchronized Pair<String, String> getDiscoveredConfig() {
        return this.myDiscoveredConfig;
    }

    private synchronized void proxyDiscovered(Proxy proxy) {
        SocketAddress address;
        if (this.myDiscoveredConfig == null && (address = proxy.address()) instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            this.myDiscoveredConfig = LicensingProxyService.getPair(inetAddress.getHostName(), inetAddress.getPort());
        }
    }

    @Nullable
    private synchronized Proxy getUserDefinedProxy() {
        Pair<String, String> hostPort = this.myProxyConfig;
        if (hostPort != null) {
            try {
                return new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved((String)hostPort.first, Integer.parseInt((String)hostPort.second)));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Throwable e2) {
                LOG.info(e2.getClass().getName() + ": " + e2.getMessage());
            }
        }
        return null;
    }

    private class LicensingProxyAuthenticator
    extends NonStaticAuthenticator {
        private LicensingProxyAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (!LicensingProxyService.isActive()) {
                LicensingProxyService.this.unregisterCustomSelector();
                return null;
            }
            try {
                Trinity<String, char[], Boolean> answer;
                if (!Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType())) {
                    return null;
                }
                Pair<String, String> hostPort = LicensingProxyService.this.getProxyConfig();
                if (hostPort == null) {
                    hostPort = LicensingProxyService.this.getDiscoveredConfig();
                }
                String requestHost = CommonProxy.getHostNameReliably((String)this.getRequestingHost(), (InetAddress)this.getRequestingSite(), (URL)this.getRequestingURL());
                int requestPort = this.getRequestingPort();
                if (hostPort == null || !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)hostPort.first), (CharSequence)requestHost) || Integer.parseInt((String)hostPort.second) != requestPort) {
                    return null;
                }
                Pair auth = LicensingProxyService.this.getProxyAuth();
                if (auth == null && !GraphicsEnvironment.isHeadless() && (answer = this.promptPassword(requestHost + ":" + requestPort)) != null) {
                    auth = LicensingProxyService.getPair((String)answer.getFirst(), (char[])answer.getSecond());
                    LicensingProxyService.this.setUserDefinedProxy(requestHost, String.valueOf(requestPort), (Pair<String, char[]>)((Boolean)answer.getThird() != false ? auth : null));
                }
                return auth != null ? new PasswordAuthentication((String)auth.first, (char[])auth.second) : null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Nullable
        private Trinity<String, char[], Boolean> promptPassword(String requestAddress) {
            return (Trinity)UIUtil.invokeAndWaitIfNeeded(() -> {
                Window parent = null;
                for (Window win : Window.getWindows()) {
                    if (win.isActive() && win.isShowing()) {
                        parent = win;
                        break;
                    }
                    if (parent != null || !win.isShowing()) continue;
                    parent = win;
                }
                if (parent == null) {
                    return null;
                }
                AuthenticationDialog dialog2 = new AuthenticationDialog((Component)parent, "Proxy authentication", "Please enter credentials for " + requestAddress, "", "", false);
                dialog2.show();
                if (dialog2.getExitCode() == 0) {
                    AuthenticationPanel panel2 = dialog2.getPanel();
                    return Trinity.create((Object)panel2.getLogin(), (Object)panel2.getPassword(), (Object)panel2.isRememberPassword());
                }
                return null;
            });
        }
    }

    private final class CompoundProxySelector
    extends ProxySelector {
        private final List<ProxySelector> myDelegates;

        public CompoundProxySelector(List<ProxySelector> delegates) {
            if (delegates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegates", "com/intellij/ide/license/impl/LicensingProxyService$CompoundProxySelector", "<init>"));
            }
            this.myDelegates = delegates;
        }

        @Override
        public List<Proxy> select(URI uri2) {
            Proxy userDefined;
            SmartList proxyList = new SmartList();
            HashSet<Proxy> foundProxies = new HashSet<Proxy>();
            String protocol2 = uri2.getScheme();
            if (("https".equalsIgnoreCase(protocol2) || "http".equalsIgnoreCase(protocol2)) && (userDefined = LicensingProxyService.this.getUserDefinedProxy()) != null && foundProxies.add(userDefined)) {
                proxyList.add(userDefined);
            }
            if (LicensingProxyService.this.myUseAutodiscoveredConfig) {
                for (ProxySelector delegate2 : this.myDelegates) {
                    try {
                        List<Proxy> proxies = delegate2.select(uri2);
                        if (proxies == null) continue;
                        for (Proxy proxy : proxies) {
                            if (proxy.type() != Proxy.Type.HTTP || !foundProxies.add(proxy)) continue;
                            LicensingProxyService.this.proxyDiscovered(proxy);
                            proxyList.add(proxy);
                        }
                    }
                    catch (Throwable e2) {
                        LOG.info(e2.getClass().getName() + ": " + e2.getMessage());
                    }
                }
            }
            if (proxyList.isEmpty()) {
                proxyList.add(Proxy.NO_PROXY);
            }
            return proxyList;
        }

        @Override
        public void connectFailed(URI uri2, SocketAddress sa, IOException ioe) {
            InetSocketAddress addr;
            Pair<String, String> config = LicensingProxyService.this.getProxyConfig();
            if (config != null && sa instanceof InetSocketAddress && StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)config.first), (CharSequence)(addr = (InetSocketAddress)sa).getHostName())) {
                SharedProxyConfig.clear();
            }
            for (ProxySelector delegate2 : this.myDelegates) {
                try {
                    delegate2.connectFailed(uri2, sa, ioe);
                }
                catch (Throwable e2) {
                    LOG.info(e2.getClass().getName() + ": " + e2.getMessage());
                }
            }
        }
    }

    private static final class InstanceHolder {
        static final LicensingProxyService ourInstance = new LicensingProxyService();

        private InstanceHolder() {
        }
    }
}

